/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.theme;


/**
 * Mixed theme. Mixed theme is based on two original themes, using the first
 * theme for the left part of the painting, the second theme for the right part
 * of the painting, and the theme blend gradient in the middle. Here is how you
 * can create and set a mixed theme:<br>
 * <br>
 * 
 * <code>
 * SubstanceTheme mixed = new SubstanceMixBiTheme(<br>
 * &nbsp;&nbsp;SubstanceAquaTheme(), SubstanceBottleGreenTheme());<br>
 * SubstanceLookAndFeel.setCurrentTheme(mixed);<br>
 * for (Frame frame : Frame.getFrames()) {<br>
 * &nbsp;&nbsp;SwingUtilities.updateComponentTreeUI(frame);<br>
 * }
 * </code><br>
 * 
 * @author Kirill Grouchnikov
 * @deprecated since version 3.1, use {@link SubstanceMixTheme}.
 */
@Deprecated
public class SubstanceMixBiTheme extends SubstanceMixTheme {
	/**
	 * Creates a new mixed theme.
	 * 
	 * @param originalFirstTheme
	 *            The first original theme.
	 * @param originalSecondTheme
	 *            The second original theme.
	 */
	public SubstanceMixBiTheme(SubstanceTheme originalFirstTheme,
			SubstanceTheme originalSecondTheme) {
		super(originalFirstTheme, originalSecondTheme);
	}
}
