#ifndef _x11_h_
#define _x11_h_

#include <X11/Xlib.h>

#ifdef MITSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

#include "3d.h"

typedef struct
{
    Display	*display;
    Screen	*screen;
    int		screen_num;
    Visual	*visual;
    Window	window;
    GC		gc;
    XImage	*image;
    uint8	*image_date;
    int		bytes_per_line;
    int		bytes_per_pixel;
    uint8	*output_screen;
    uint32	output_pitch;
    uint8	*interpolated_screen;
    uint8	*delta_screen;
    Colormap	cmap;
    Cursor	point_cursor;
    Cursor	cross_hair_cursor;
    XColor	colors [256];
    bool8	pseudo;
    bool8	grayscale;
    uint8	interpolate;
    bool8	image_needs_scaling;
    bool8	scale;
    int		depth;
    int		window_width;
    int		window_height;
    int		last_snes_width;
    int		last_snes_height;
    uint32	red_shift;
    uint32	blue_shift;
    uint32	green_shift;
    uint32	red_size;
    uint32	green_size;
    uint32	blue_size;
    int		mouse_x;
    int		mouse_y;
    uint32	mouse_buttons;
    bool8	mod1_pressed;
    bool8	superscope;
    uint32	superscope_turbo;
    uint32	superscope_pause;
    XRectangle  box;
    XRectangle  old_box;

    XColor	fixed_colours [256];
    uint8	palette [0x10000];
    char	info_string [256];
    void	*to_free [6];
#ifdef MITSHM
    XShmSegmentInfo sm_info;
    int		use_shared_memory;
#endif
#ifdef USE_OPENGL
    GLXContext  glcontext;
#endif
} GUIData;

extern GUIData GUI;
#endif
