# coding: utf-8
=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Skin prepared for Viral Spiral, David Bollier
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require SiSU_lib + '/defaults'
  class Skin
    def url_home
      'http://viralspiral.cc/'
    end
    def url_txt                                                                      # text to go with url usually stripped url
      'viralspiral.cc'
    end
    def url_author
      'http://www.bollier.org/'
    end
    def color_band1
      '"#ffffff"'
    end
    def txt_hp
      'viralspiral.cc'
    end
    def txt_home
      'David Bollier'
    end
    def icon_home_button
      ''
    end
    def icon_home_banner
      icon_home_button
    end
    def banner_home_button
      %{<table summary="home button" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_white}><a href="#{url_home}">#{png_home}</a></td></tr></table>\n}
    end
    def banner_home_and_index_buttons
      %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_white}><a href="#{url_home}" target="_top">#{png_home}</a></td><td width="40%"><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc.html" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font>#{table_close}</center></td><td width="20%">&nbsp;#{table_close}}
    end
    def banner_band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#ffffff">
      <p class="tiny_left"><a href="#{url_site}/" target="_top">Viral Spiral</a></p>
      <p class="tiny_left"><a href="#{url_author}/" target="_top">David Bollier</a></p>
      #{table_close}}
    end
    def credits_splash
      %{<table summary="credits" align="center" bgcolor="#ffffff"><tr><td><font color="black"><center>
<a href="#{url_home}">Viral Spiral, David Bollier</a><br />
<a href="#{url_home}">The original pdf is available online</a> at<br /><a href="#{url_home}">#{url_txt}</a><br />
available at<br /><a href="http://www.amazon.com/Viral-Spiral-Commoners-Digital-Republic/dp/1595583963">Amazon.com</a> and <br />
<a href="http://search.barnesandnoble.com/booksearch/isbnInquiry.asp?isbn=1595583963">Barnes & Noble</a><br />
This book is Copyright David Bollier © 2008<br />
Under a Creative Commons License, License: Attribution-Noncommercial Works (CC-BY-NC) 3.0
<a href="http://creativecommons.org/licenses/by-nc/3.0/">http://creativecommons.org/licenses/by-nc/3.0/</a></center></font></td></tr></table>}
    end
  end
  class TeX
    def header_center
	    "\\chead{\\href{#{@vz.url_home}}{#{@vz.url_txt}}}"
    end
    def home_url
	    "\\href{#{@vz.url_home}}{#{@vz.url_txt}}"
    end
    def home
	    "\\href{#{@vz.url_home}}{David Bollier}"
    end
    def owner_chapter
      "Document owner details"
    end
  end
end
__END__
