.TH path_2_nodes 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
path_2_nodes - set of nodes from a path
.SH CALLING SEQUENCE
.nf
ns = path_2_nodes(p,g)
.fi
.SH PARAMETERS
.TP 2
p
: row vector of integer numbers of the arcs of the path
.TP 2
g
: graph list
.TP 3
ns
: row vector of integer numbers of the set of nodes
.SH DESCRIPTION
\fVpath_2_nodes\fR returns the set of nodes \fVns\fR corresponding to the 
path \fVp\fR given by its arc numbers ; if \fVp\fR is not a path, the
empty vector \fV[]\fR is returned.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 11 12 13 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 15 12 13 9 10 14 11 16 1 17 14 15];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
show_graph(g);
p=[2 16 23 25 26 22 17 18 19 13 10 11];
g1=g; edgecolor=1*ones(ta); edgecolor(p)=11*ones(p);
g1('edge_color')=edgecolor;
show_graph(g1); show_arcs(p);
ns=path_2_nodes(p,g);
g1=g; nodecolor=1*ones(g1('node_number')); nodecolor(ns)=11*ones(ns);
g1('node_color')=nodecolor;
show_graph(g1);show_nodes(ns);
show_arcs(p,'sup');
.fi
.SH SEE ALSO
nodes_2_path
