.TH plot2d2 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
plot2d2 - 2D plot (step function)
.SH CALLING SEQUENCE
.nf
plot2d2([x],y)
plot2d2([x],y,<opt_args>)
plot2d2([logflag],x,y,[style,strf,leg,rect,nax])
.fi
.SH PARAMETERS
[ ]
: see \fVplot2d\fR for a description of parameters.
.SH DESCRIPTION
\fVplot2d2\fR is the same as \fVplot2d\fR but the functions given by
\fV(x,y)\fR are supposed to be piecewise constant. 

By default, successive plots are superposed. To clear the previous plot, 
use \fVxbasc()\fR.

Enter the command \fVplot2d2()\fR to see a demo.
.SH EXAMPLE
.nf
// plots a step function of value i on the segment [i,i+1]
// the last segment is not drawn
plot2d2([1:4],[1:4],1,"111","step function",[0,0,5,5])
// compare the following with plot2d
x=[0:0.1:2*%pi]';
xbasc()
plot2d2(x,[sin(x) sin(2*x) sin(3*x)])
.fi
.SH SEE ALSO
plot2d, plot2d3, plot2d4, subplot, xbasc, xset
.SH AUTHOR
J.Ph.C.
