.TH dscr 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
dsimul -  state space discrete time simulation 
.SH CALLING SEQUENCE
.nf
y=dsimul(sl,u)
.fi
.SH PARAMETERS
.TP 10
sl
: \fVsyslin\fR list describing a discrete time linear system
.TP
u
: real matrix of appropriate dimension
.TP
y
: output of \fVsl\fR
.SH DESCRIPTION
Utility function. 
If \fV[A,B,C,D]=abcd(sl)\fR and \fVx0=sl('X0')\fR, \fVdsimul\fR returns \fVy=C*ltitr(A,B,u,x0)+D*u\fR i.e.
the time response of \fVsl\fR to the input \fVu\fR.
\fVsl\fR is assumed to be in state space form (\fVsyslin\fR list).
.SH EXAMPLE
.nf
z=poly(0,'z');
h=(1-2*z)/(z^2-0.2*z+1);
sl=tf2ss(h);
u=zeros(1,20);u(1)=1;
x1=dsimul(sl,u)   //Impulse response
u=ones(1,20);
x2=dsimul(sl,u);  //Step response
.fi
.SH SEE ALSO
syslin, flts, ltitr


