#include <Message_MsgFile.ixx>

#include <Dico_DictionaryOfTransient.hxx>
#include <TCollection_AsciiString.hxx>
#include <TCollection_HAsciiString.hxx>
#include <OSD.hxx> 
#include <OSD_File.hxx>
#include <OSD_Path.hxx>
#include <OSD_Protection.hxx>  
#include <OSD_Environment.hxx>


static Handle(Dico_DictionaryOfTransient)& msgs ()
{
  static Handle(Dico_DictionaryOfTransient) themsg;
  if (themsg.IsNull()) themsg = new Dico_DictionaryOfTransient();
  return themsg;
}

//=======================================================================
//function : LoadFile
//purpose  : 
//=======================================================================

Standard_Integer  Message_MsgFile::LoadFile
  (const Standard_CString filename)
{  
  
  OSD_File messFil = OSD_File(OSD_Path(filename));
  OSD_Protection Pr;
  Standard_Integer leng = 0, locp, locex,loc;
  if (!messFil.Exists()) { 
#ifdef DEB 
    cout << "Warning: Message_MsgFile::LoadFile: message file " << filename << " does not exist" << endl;
#endif
    return 0;
  }
  messFil.Open (OSD_ReadOnly,Pr);
  TCollection_AsciiString temp,tempstr,str,code;
  while (!messFil.IsAtEnd()) {
    messFil.ReadLine(tempstr,255,leng);
    if (tempstr.IsEmpty()) continue;
    temp.Copy(tempstr);
    temp.LeftAdjust();
    if (temp.Length()) {
      locp = temp.Location(1,'.',1,1);
      locex = temp.Location(1,'!',1,1);
    }
    else { locp = 0; locex = 0;} 
    if (locp) { 
      if (!str.IsEmpty() && !code.IsEmpty()) { 
	loc = str.SearchFromEnd("\n"); 
	if(loc != -1 && loc) str.Trunc(--loc);
	AddMsg(code.ToCString(),str.ToCString()); 
	code.Clear();
      }
      temp = temp.SubString(locp + 1, temp.Length());
      code.Copy(temp.Token("\n"));
      str.Clear();
    }
    else if(locex != 1) { str.AssignCat(tempstr);  }
  }
  if(!str.IsEmpty() && !code.IsEmpty()) {
    loc = str.SearchFromEnd("\n"); 
    if(loc != -1 && loc) str.Trunc(--loc);
    AddMsg(code.ToCString(),str.ToCString());
  }
  messFil.Close();
  return 0;  
}    

//=======================================================================
//function : LoadFromEnv
//purpose  : 
//=======================================================================
void  Message_MsgFile::LoadFromEnv
  (const Standard_CString envname,
   const Standard_CString filename,
   const Standard_CString ext)
{
  Standard_CString extname = ext;
  TCollection_AsciiString extstr;
  if (!extname || extname[0] == '\0') {
    OSD_Environment extenv("CSF_LANGUAGE");
    extstr  = extenv.Value();
    extname = extstr.ToCString();
  }
  if (!extname || extname[0] == '\0') extname = "us";

  TCollection_AsciiString filestr(filename);
  if (envname && envname[0] != '\0') {
    OSD_Environment envenv(envname);
    TCollection_AsciiString envstr  = envenv.Value();
    if (envstr.Length() > 0) {
      if (envstr.Value(envstr.Length()) != '/') filestr.Insert (1,'/');
      filestr.Insert (1,envstr.ToCString());
    }
  }
  if (extname[0] != '.') filestr.AssignCat ('.');
  filestr.AssignCat (extname);

//  cout<<"  Message_MsgFile::LoadFile "<<filestr.ToCString()<<endl;

  Message_MsgFile::LoadFile (filestr.ToCString());
}


//=======================================================================
//function : AddMsg
//purpose  : 
//=======================================================================

void  Message_MsgFile::AddMsg
  (const Standard_CString code, const Standard_CString text)
{
  Handle(TCollection_HAsciiString) str = new TCollection_HAsciiString(text);
  msgs()->SetItem (code,str);
}

//=======================================================================
//function : Msg
//purpose  : 
//=======================================================================

Standard_CString  Message_MsgFile::Msg (const Standard_CString code)
{
  Handle(TCollection_HAsciiString) str;
  if (!msgs()->GetItem (code,str)) return code;
  if (str.IsNull()) return "";
  return str->ToCString();
}
