/* VPSCR2.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mvpscr2_(ncoeff, curve2, tparam, pntcrb)
integer *ncoeff;
doublereal *curve2, *tparam, *pntcrb;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer ndeg, kk;
    static doublereal xxx, yyy;



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*  POSITIONNEMENT SUR UNE COURBE (NCF,2) DANS L'ESPACE DE DIMENSION 2. */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS,MATH_ACCES:: COURBE&,POSITIONNEMENT,&POINT. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*     NCOEFF : NOMBRE DE COEFFICIENTS DE LA COURBE */
/*     CURVE2 : EQUATION DE LA COURBE 2D */
/*     TPARAM : VALEUR DU PARAMETRE AU POINT CONSIDERE */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*     PNTCRB : COORDONNEES DU POINT CORRESPONDANT AU PARAMETRE */
/*              TPARAM SUR LA COURBE 2D CURVE2. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ---------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     MSCHEMA DE HORNER. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     16-05-90 : RBD; Optimisation sur une idee de GD. */
/*     12-09-86 : NAK;ECRITURE VERSION ORIGINALE */
/* > */
/* ********************************************************************** 
*/


/* -------- INITIALISATIONS ET TRAITEMENT DES CAS PARTICULIERS ---------- 
*/

/* ---> Cas ou NCOEFF > 1 (cas STANDARD). */
    /* Parameter adjustments */
    --pntcrb;
    curve2 -= 3;

    /* Function Body */
    if (*ncoeff >= 2) {
	goto L1000;
    }
/* ---> Cas ou NCOEFF <= 1. */
    if (*ncoeff <= 0) {
	pntcrb[1] = 0.;
	pntcrb[2] = 0.;
	goto L9999;
    } else if (*ncoeff == 1) {
	pntcrb[1] = curve2[3];
	pntcrb[2] = curve2[4];
	goto L9999;
    }

/* -------------------- MSCHEMA DE HORNER (CAS PARTICULIER) --------------
 */

L1000:

    if (*tparam == 1.) {
	xxx = 0.;
	yyy = 0.;
	i__1 = *ncoeff;
	for (kk = 1; kk <= i__1; ++kk) {
	    xxx += curve2[(kk << 1) + 1];
	    yyy += curve2[(kk << 1) + 2];
/* L100: */
	}
	goto L5000;
    } else if (*tparam == 0.) {
	pntcrb[1] = curve2[3];
	pntcrb[2] = curve2[4];
	goto L9999;
    }

/* ---------------------------- MSCHEMA DE HORNER ------------------------
 */
/* ---> Ici TPARAM est different de 1.D0 et de 0.D0. */

    ndeg = *ncoeff - 1;
    xxx = curve2[(*ncoeff << 1) + 1];
    yyy = curve2[(*ncoeff << 1) + 2];
    for (kk = ndeg; kk >= 1; --kk) {
	xxx = xxx * *tparam + curve2[(kk << 1) + 1];
	yyy = yyy * *tparam + curve2[(kk << 1) + 2];
/* L200: */
    }
    goto L5000;

/* ------------------------ RECUPERATION DU POINT CALCULE --------------- 
*/

L5000:
    pntcrb[1] = xxx;
    pntcrb[2] = yyy;

/* ------------------------------ THE END ------------------------------- 
*/

L9999:
    return 0;
} /* mvpscr2_ */

