
#define VIRTUAL

// File		Graphic3d_GraphicDriver_5.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL
//      02.15.100 : JR : Clutter

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <Graphic3d_GraphicDriver.jxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

//-Aliases

//-Global data definitions

//-Methods, in order

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::DumpGroup (const Graphic3d_CGroup& ) {
#else
void Graphic3d_GraphicDriver::DumpGroup (const Graphic3d_CGroup& ACGroup) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (long, long, long) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_structure_exploration");
	    //fp = (void (*)(long, long, long)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_structure_exploration");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_structure_exploration
(long (MyCGroup.Struct->Id), long (MyCGroup.LabelBegin), long (MyCGroup.LabelEnd));

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::DumpStructure (const Graphic3d_CStructure& ) {
#else
void Graphic3d_GraphicDriver::DumpStructure (const Graphic3d_CStructure& ACStructure) {

Graphic3d_CStructure MyCStructure = ACStructure;

//static void (*fp) (long, long, long) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_structure_exploration");
	    //fp = (void (*)(long, long, long)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_structure_exploration");
		PrintCStructure (MyCStructure, 1);
	}
	call_togl_structure_exploration (long (MyCStructure.Id), 0, 0);

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::DumpView (const Graphic3d_CView& ) {
#else
void Graphic3d_GraphicDriver::DumpView (const Graphic3d_CView& ACView) {

Graphic3d_CView MyCView = ACView;

//static void (*fp) (long) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_view_exploration");
	    //fp = (void (*)(long)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_view_exploration");
		PrintCView (MyCView, 1);
	}
	call_togl_view_exploration (long (MyCView.ViewId));

#endif
}

#ifdef VIRTUAL
Standard_Boolean Graphic3d_GraphicDriver::ElementExploration (const Graphic3d_CStructure & , const Standard_Integer , Graphic3d_VertexNC& , Graphic3d_Vector& ) {
	return Standard_False;
#else
Standard_Boolean Graphic3d_GraphicDriver::ElementExploration (const Graphic3d_CStructure & ACStructure, const Standard_Integer ElementNumber, Graphic3d_VertexNC& AVertex, Graphic3d_Vector& AVector) {

Graphic3d_CStructure MyCStructure = ACStructure;

//static void (*fp) (long, long, long *, CALL_DEF_POINT *, CALL_DEF_NORMAL *, CALL_DEF_COLOR *, CALL_DEF_NORMAL *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_element_exploration");
	    //fp = (void (*)(long, long, long *, CALL_DEF_POINT *, CALL_DEF_NORMAL *, CALL_DEF_COLOR *, CALL_DEF_NORMAL *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

Quantity_Color AColor;
long AType;

CALL_DEF_POINT Pt;
CALL_DEF_NORMAL Npt, Nfa;
CALL_DEF_COLOR Cpt;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_element_exploration");
		PrintCStructure (MyCStructure, 1);
	}
	call_togl_element_exploration (MyCStructure.Id, ElementNumber, &AType, &Pt, &Npt, &Cpt, &Nfa);

	if (! AType) return (Standard_False);
	else {
		AVertex.SetCoord
			(double (Pt.x), double (Pt.y), double (Pt.z));
		AVertex.SetNormal
			(double (Npt.dx), double (Npt.dy), double (Npt.dz));
		AColor.SetValues
			(double (Cpt.r), double (Cpt.g),
				double (Cpt.b), Quantity_TOC_RGB);
		AVertex.SetColor (AColor);
		AVector.SetCoord
			(double (Nfa.dx), double (Nfa.dy), double (Nfa.dz));
		return (Standard_True);
	}
#endif
}

#ifdef VIRTUAL
Graphic3d_TypeOfPrimitive Graphic3d_GraphicDriver::ElementType (const Graphic3d_CStructure & , const Standard_Integer ) {
	return Graphic3d_TOP_UNDEFINED;
#else
Graphic3d_TypeOfPrimitive Graphic3d_GraphicDriver::ElementType (const Graphic3d_CStructure & ACStructure, const Standard_Integer ElementNumber) {

Graphic3d_CStructure MyCStructure = ACStructure;

//static void (*fp) (long, long, long *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_element_type");
	    //fp = (void (*)(long, long, long *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

long AType;
Graphic3d_TypeOfPrimitive top;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_element_type");
		PrintCStructure (MyCStructure, 1);
	}
	call_togl_element_type (MyCStructure.Id, ElementNumber, &AType);

	switch (AType) {

		case 0:
			top	= Graphic3d_TOP_UNDEFINED;
		break;
		case 1:
			top	= Graphic3d_TOP_POLYLINE;
		break;
		case 2:
			top	= Graphic3d_TOP_POLYGON;
		break;
		case 3:
			top	= Graphic3d_TOP_TRIANGLEMESH;
		break;
		case 4:
			top	= Graphic3d_TOP_QUADRANGLEMESH;
		break;
		case 5:
			top	= Graphic3d_TOP_TEXT;
		break;
		case 6:
			top	= Graphic3d_TOP_MARKER;
		break;
		default:
			top	= Graphic3d_TOP_UNDEFINED;
		break;

	}

	return (top);
#endif
}
