// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _STEPEdit_HeaderFile
#define _STEPEdit_HeaderFile

#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_StepData_StepModel_HeaderFile
#include <Handle_StepData_StepModel.hxx>
#endif
#ifndef _Handle_IFSelect_Signature_HeaderFile
#include <Handle_IFSelect_Signature.hxx>
#endif
#ifndef _Handle_IFSelect_SelectSignature_HeaderFile
#include <Handle_IFSelect_SelectSignature.hxx>
#endif
class Interface_Protocol;
class StepData_StepModel;
class IFSelect_Signature;
class IFSelect_SelectSignature;
class STEPEdit_EditContext;
class STEPEdit_EditSDR;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides tools to exploit and edit a set of STEP data : <br>
//!           editors, selections .. <br>
class STEPEdit  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns a Protocol fit for STEP (creates the first time) <br>
Standard_EXPORT static  Handle_Interface_Protocol Protocol() ;

//! Returns a new empty StepModel fit for STEP <br>
//!           i.e. with its header determined from Protocol <br>
Standard_EXPORT static  Handle_StepData_StepModel NewModel() ;

//! Returns a SignType fit for STEP (creates the first time) <br>
Standard_EXPORT static  Handle_IFSelect_Signature SignType() ;

//! Creates a Selection for ShapeDefinitionRepresentation <br>
//!           By default searches among root entities <br>
Standard_EXPORT static  Handle_IFSelect_SelectSignature NewSelectSDR() ;

//! Creates a Selection for Placed Items, i.e. MappedItem or <br>
//!           ContextDependentShapeRepresentation, which itself refers to a <br>
//!           RepresentationRelationship with possible subtypes (Shape... <br>
//!           and/or ...WithTransformation) <br>
//!           By default in the whole StepModel <br>
Standard_EXPORT static  Handle_IFSelect_SelectSignature NewSelectPlacedItem() ;

//! Creates a Selection for ShapeRepresentation and its sub-types, <br>
//!           plus ContextDependentShapeRepresentation (which is not a <br>
//!           sub-type of ShapeRepresentation) <br>
//!           By default in the whole StepModel <br>
Standard_EXPORT static  Handle_IFSelect_SelectSignature NewSelectShapeRepr() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class STEPEdit_EditContext;
friend class STEPEdit_EditSDR;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
