// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_HGraph_HeaderFile
#define _Interface_HGraph_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Interface_HGraph_HeaderFile
#include <Handle_Interface_HGraph.hxx>
#endif

#ifndef _Interface_Graph_HeaderFile
#include <Interface_Graph.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_Interface_GTool_HeaderFile
#include <Handle_Interface_GTool.hxx>
#endif
class Standard_DomainError;
class Interface_Graph;
class Interface_InterfaceModel;
class Interface_GeneralLib;
class Interface_Protocol;
class Interface_GTool;


//! This class allows to store a redefinable Graph, via a Handle <br>
//!           (usefull for an Object which can work on several successive <br>
//!           Models, with the same general conditions) <br>
class Interface_HGraph : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates an HGraph directly from a Graph. <br>
//!           Remark that the starting Graph is duplicated <br>
Standard_EXPORT Interface_HGraph(const Interface_Graph& agraph);

//! Creates an HGraph with a Graph created from <amodel> and <lib> <br>
Standard_EXPORT Interface_HGraph(const Handle(Interface_InterfaceModel)& amodel,const Interface_GeneralLib& lib);

//! Creates an HGraph with a graph itself created from <amodel> <br>
//!           and <protocol> <br>
Standard_EXPORT Interface_HGraph(const Handle(Interface_InterfaceModel)& amodel,const Handle(Interface_Protocol)& protocol);

//! Creates an HGraph with a graph itself created from <amodel> <br>
//!           and <protocol> <br>
Standard_EXPORT Interface_HGraph(const Handle(Interface_InterfaceModel)& amodel,const Handle(Interface_GTool)& gtool);

//! Same a above, but works with the GTool in the model <br>
Standard_EXPORT Interface_HGraph(const Handle(Interface_InterfaceModel)& amodel);

//! Returns the Graph contained in <me>, for Read Only Operations <br>
//!           Remark that it is returns as "const &" <br>
//!           Getting it in a new variable instead of a reference would be <br>
//!           a pitty, because all the graph's content would be duplicated <br>
Standard_EXPORT  const Interface_Graph& Graph() const;

//! Same as above, but for Read-Write Operations <br>
//!           Then, The Graph will be modified in the HGraph itself <br>
Standard_EXPORT   Interface_Graph& CGraph() ;
//Standard_EXPORT ~Interface_HGraph();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Interface_Graph thegraph;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
