// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic3d_TextureRoot_HeaderFile
#define _Graphic3d_TextureRoot_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic3d_TextureRoot_HeaderFile
#include <Handle_Graphic3d_TextureRoot.hxx>
#endif

#ifndef _Handle_Graphic3d_GraphicDriver_HeaderFile
#include <Handle_Graphic3d_GraphicDriver.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Graphic3d_CInitTexture_HeaderFile
#include <Graphic3d_CInitTexture.hxx>
#endif
#ifndef _OSD_Path_HeaderFile
#include <OSD_Path.hxx>
#endif
#ifndef _Graphic3d_TypeOfTexture_HeaderFile
#include <Graphic3d_TypeOfTexture.hxx>
#endif
#ifndef _Handle_AlienImage_AlienImage_HeaderFile
#include <Handle_AlienImage_AlienImage.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_Graphic3d_StructureManager_HeaderFile
#include <Handle_Graphic3d_StructureManager.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Graphic3d_GraphicDriver;
class AlienImage_AlienImage;
class TColStd_HArray1OfReal;
class Graphic3d_StructureManager;
class OSD_Path;


//! This is the texture root class enable the dialog with the GraphicDriver <br>
//! allows the loading of texture too supported formats: <br>
//! X, SunRaster, Aida, Euclid, SGI rgb <br>
class Graphic3d_TextureRoot : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT   void Destroy() const;
~Graphic3d_TextureRoot()
{
  Destroy();
}


//! Checks if a texture class is valide or not <br>
//! returns true if the construction of the class is correct <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//! Returns the full path of the defined texture. <br>
Standard_EXPORT  const OSD_Path& Path() const;


//! Returns the texture type. <br>
Standard_EXPORT   Graphic3d_TypeOfTexture Type() const;


//! Updates the current texture from a requested alien image. <br>
Standard_EXPORT   void LoadTexture(const Handle(AlienImage_AlienImage)& anImage) ;


//! returns the Texture ID which references the <br>
//! texture to use for drawing. Used by the <br>
//! graphic driver. <br>
Standard_EXPORT   Standard_Integer TextureId() const;


//! Returns the created image texture. <br>
Standard_EXPORT   Handle_AlienImage_AlienImage Image() const;


Standard_EXPORT   Handle_TColStd_HArray1OfReal GetTexUpperBounds() const;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Creates a texture from a file <br>
//!  Warning: Note that if <FileName> is NULL the texture must be realized <br>
//! using LoadTexture(image) method. <br>
Standard_EXPORT Graphic3d_TextureRoot(const Handle(Graphic3d_StructureManager)& SM,const Standard_CString Path,const Standard_CString FileName,const Graphic3d_TypeOfTexture Type);


Standard_EXPORT   void Update() const;


 // Fields PROTECTED
 //
Graphic3d_CInitTexture MyCInitTexture;


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Handle_AlienImage_AlienImage LoadTexture() const;


 // Fields PRIVATE
 //
Handle_Graphic3d_GraphicDriver MyGraphicDriver;
Standard_Integer MyTexId;
OSD_Path MyPath;
Graphic3d_TypeOfTexture MyType;
Handle_AlienImage_AlienImage MyImage;
Handle_TColStd_HArray1OfReal MyTexUpperBounds;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
