// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Expr_BinaryExpression_HeaderFile
#define _Expr_BinaryExpression_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Expr_BinaryExpression_HeaderFile
#include <Handle_Expr_BinaryExpression.hxx>
#endif

#ifndef _Handle_Expr_GeneralExpression_HeaderFile
#include <Handle_Expr_GeneralExpression.hxx>
#endif
#ifndef _Expr_GeneralExpression_HeaderFile
#include <Expr_GeneralExpression.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Expr_NamedUnknown_HeaderFile
#include <Handle_Expr_NamedUnknown.hxx>
#endif
class Expr_GeneralExpression;
class Standard_OutOfRange;
class Standard_NumericError;
class Expr_InvalidOperand;
class Expr_NamedUnknown;


//! Defines all binary expressions. The order of the two <br>
//!          operands is significant. <br>
class Expr_BinaryExpression : public Expr_GeneralExpression {

public:
 // Methods PUBLIC
 // 

 const Handle_Expr_GeneralExpression& FirstOperand() const;

 const Handle_Expr_GeneralExpression& SecondOperand() const;

//! Sets first operand of <me> <br>
//!          Raises InvalidOperand if exp = me <br>
Standard_EXPORT   void SetFirstOperand(const Handle(Expr_GeneralExpression)& exp) ;

//! Sets second operand of <me> <br>
//!          Raises InvalidOperand if <exp> contains <me>. <br>
Standard_EXPORT   void SetSecondOperand(const Handle(Expr_GeneralExpression)& exp) ;

//! returns the number of sub-expressions contained <br>
//!          in <me> ( >= 0) <br>
Standard_EXPORT   Standard_Integer NbSubExpressions() const;

//! returns the <I>-th sub-expression of <me> <br>
//!          raises OutOfRange if <I> > NbSubExpressions(me) <br>
Standard_EXPORT  const Handle_Expr_GeneralExpression& SubExpression(const Standard_Integer I) const;

//! Does <me> contain NamedUnknown ? <br>
Standard_EXPORT   Standard_Boolean ContainsUnknowns() const;

//! Tests if <me> contains <exp>. <br>
Standard_EXPORT   Standard_Boolean Contains(const Handle(Expr_GeneralExpression)& exp) const;

//! Replaces all occurences of <var> with <with> in <me>. <br>
//!          Raises InvalidOperand if <with> contains <me>. <br>
Standard_EXPORT   void Replace(const Handle(Expr_NamedUnknown)& var,const Handle(Expr_GeneralExpression)& with) ;

//! Returns a GeneralExpression after replacement of <br>
//!          NamedUnknowns by an associated expression and after <br>
//!          values computation. <br>
Standard_EXPORT   Handle_Expr_GeneralExpression Simplified() const;
//Standard_EXPORT ~Expr_BinaryExpression();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Sets first operand of <me> <br>
Standard_EXPORT   void CreateFirstOperand(const Handle(Expr_GeneralExpression)& exp) ;

//! Sets second operand of <me> <br>
//!          Raises InvalidOperand if <exp> contains <me>. <br>
Standard_EXPORT   void CreateSecondOperand(const Handle(Expr_GeneralExpression)& exp) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Expr_GeneralExpression myFirstOperand;
Handle_Expr_GeneralExpression mySecondOperand;


};


#include <Expr_BinaryExpression.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
