// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AIS_DiameterDimension_HeaderFile
#define _AIS_DiameterDimension_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_AIS_DiameterDimension_HeaderFile
#include <Handle_AIS_DiameterDimension.hxx>
#endif

#ifndef _gp_Circ_HeaderFile
#include <gp_Circ.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _AIS_Relation_HeaderFile
#include <AIS_Relation.hxx>
#endif
#ifndef _DsgPrs_ArrowSide_HeaderFile
#include <DsgPrs_ArrowSide.hxx>
#endif
#ifndef _AIS_KindOfDimension_HeaderFile
#include <AIS_KindOfDimension.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager3d_HeaderFile
#include <Handle_PrsMgr_PresentationManager3d.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Prs3d_Projector_HeaderFile
#include <Handle_Prs3d_Projector.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager2d_HeaderFile
#include <Handle_PrsMgr_PresentationManager2d.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Handle_Geom_Transformation_HeaderFile
#include <Handle_Geom_Transformation.hxx>
#endif
#ifndef _Handle_SelectMgr_Selection_HeaderFile
#include <Handle_SelectMgr_Selection.hxx>
#endif
#ifndef _AIS_KindOfSurface_HeaderFile
#include <AIS_KindOfSurface.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
class Standard_ConstructionError;
class TopoDS_Shape;
class TCollection_ExtendedString;
class gp_Pnt;
class PrsMgr_PresentationManager3d;
class Prs3d_Presentation;
class Prs3d_Projector;
class PrsMgr_PresentationManager2d;
class Graphic2d_GraphicObject;
class Geom_Transformation;
class SelectMgr_Selection;
class Geom_Surface;


//! A framework to display diameter dimensions. <br>
//! A diameter is displayed with arrows and text. The <br>
//! text gives the length of the diameter. <br>
//! The algorithm takes a length along a face and <br>
//! analyzes it as an arc. It then reconstructs the circle <br>
//! corresponding to the arc and calculates the <br>
//! diameter of this circle. This diameter serves as a <br>
//! relational reference in 3d presentations of the surface. <br>
class AIS_DiameterDimension : public AIS_Relation {

public:
 // Methods PUBLIC
 // 

//! Constructs a diameter display object defined by the <br>
//! shape aFShape, the dimension aVal and the text aText. <br>
Standard_EXPORT AIS_DiameterDimension(const TopoDS_Shape& aShape,const Standard_Real aVal,const TCollection_ExtendedString& aText);

//! Constructs a diameter display object defined by the <br>
//! shape aFShape, the dimension aVal and the text <br>
//! aText, the point of origin of the diameter aPosition, <br>
//! and the type of arrow aSymbolPrs with the size anArrowSize. <br>
//! If the Boolean aDiamSymbol is true. <br>
Standard_EXPORT AIS_DiameterDimension(const TopoDS_Shape& aShape,const Standard_Real aVal,const TCollection_ExtendedString& aText,const gp_Pnt& aPosition,const DsgPrs_ArrowSide aSymbolPrs,const Standard_Boolean aDiamSymbol,const Standard_Real anArrowSize = 0.0);

//! Indicates that we are concerned with a length. <br>
virtual  AIS_KindOfDimension KindOfDimension() const;

//! Returns true if the diameter dimension is movable <br>
virtual  Standard_Boolean IsMovable() const;

//! Returns the symbol for diameter dimension. This will <br>
//! be either arrow, text, or a combination of both. <br>
  Standard_Boolean DiamSymbol() ;

//! Sets the symbol for diameter dimension aDiamSymbol. <br>
//! This can be an arrow, a text or both. <br>
  void SetDiamSymbol(const Standard_Boolean aDiamSymbol) ;

//! computes the presentation according to a point of view <br>
//!          given by <aProjector>. <br>
//!          To be Used when the associated degenerated Presentations <br>
//!          have been transformed by <aTrsf> which is not a Pure <br>
//!          Translation. The HLR Prs can't be deducted automatically <br>
//!          WARNING :<aTrsf> must be applied <br>
//!           to the object to display before computation  !!! <br>
Standard_EXPORT virtual  void Compute(const Handle(Prs3d_Projector)& aProjector,const Handle(Geom_Transformation)& aTrsf,const Handle(Prs3d_Presentation)& aPresentation) ;
//Standard_EXPORT ~AIS_DiameterDimension();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT virtual  void Compute(const Handle(PrsMgr_PresentationManager3d)& aPresentationManager,const Handle(Prs3d_Presentation)& aPresentation,const Standard_Integer aMode = 0) ;


Standard_EXPORT   void Compute(const Handle(Prs3d_Projector)& aProjector,const Handle(Prs3d_Presentation)& aPresentation) ;


Standard_EXPORT   void Compute(const Handle(PrsMgr_PresentationManager2d)& aPresentationManager,const Handle(Graphic2d_GraphicObject)& aPresentation,const Standard_Integer aMode = 0) ;


Standard_EXPORT virtual  void ComputeSelection(const Handle(SelectMgr_Selection)& aSelection,const Standard_Integer aMode) ;


Standard_EXPORT   void ComputeOneFaceDiameter(const Handle(Prs3d_Presentation)& aPresentation) ;


Standard_EXPORT   void ComputeOneCylFaceDiameter(const Handle(Prs3d_Presentation)& aPresentation,const AIS_KindOfSurface aSurfType,const Handle(Geom_Surface)& aSurf) ;


Standard_EXPORT   void ComputeOnePlanarFaceDiameter(const Handle(Prs3d_Presentation)& aPresentation) ;


Standard_EXPORT   void ComputeOneEdgeDiameter(const Handle(Prs3d_Presentation)& aPresentation) ;


Standard_EXPORT   void ComputeCircleDiameter(const Handle(Prs3d_Presentation)& aPresentation) ;


Standard_EXPORT   void ComputeArcDiameter(const Handle(Prs3d_Presentation)& aPresentation,const gp_Pnt& ptFirst,const gp_Pnt& ptend) ;


Standard_EXPORT   void ComputeArcSelection(const Handle(SelectMgr_Selection)& aSelection) ;


 // Fields PRIVATE
 //
gp_Circ myCircle;
Standard_Boolean myIsAnArc;
Standard_Boolean myDiamSymbol;
Standard_Real myFirstPar;
Standard_Real myLastPar;


};


#include <AIS_DiameterDimension.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
