/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BERBitString
extends BERElement {
    private BitSet m_value;
    private int m_value_num_bits;

    public BERBitString(BitSet bitSet) {
        this.m_value = bitSet;
    }

    public BERBitString(BERTagDecoder bERTagDecoder, InputStream inputStream, int[] nArray) throws IOException {
        int n = BERElement.readLengthOctets(inputStream, nArray);
        int[] nArray2 = new int[1];
        BERElement bERElement = null;
        if (n == -1) {
            nArray2[0] = 0;
            bERElement = BERElement.getElement(bERTagDecoder, inputStream, nArray2);
            if (bERElement != null) {
                BERBitString bERBitString = (BERBitString)bERElement;
                BitSet bitSet = new BitSet(this.m_value_num_bits + bERBitString.getSize());
                int n2 = 0;
                while (n2 < this.m_value_num_bits) {
                    if (this.m_value.get(n2)) {
                        bitSet.set(n2);
                    }
                    ++n2;
                }
                int n3 = 0;
                while (n3 < bERBitString.getSize()) {
                    if (bERBitString.getValue().get(n3)) {
                        bitSet.set(this.m_value_num_bits + n3);
                    }
                    ++n3;
                }
                this.m_value = bitSet;
                this.m_value_num_bits += bERBitString.getSize();
            }
            while (bERElement != null) {
            }
            return;
        }
        nArray[0] = nArray[0] + n;
        while (n > 0) {
            nArray2[0] = 0;
            bERElement = BERElement.getElement(bERTagDecoder, inputStream, nArray2);
            if (bERElement != null) {
                BERBitString bERBitString = (BERBitString)bERElement;
                BitSet bitSet = new BitSet(this.m_value_num_bits + bERBitString.getSize());
                int n4 = 0;
                while (n4 < this.m_value_num_bits) {
                    if (this.m_value.get(n4)) {
                        bitSet.set(n4);
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < bERBitString.getSize()) {
                    if (bERBitString.getValue().get(n5)) {
                        bitSet.set(this.m_value_num_bits + n5);
                    }
                    ++n5;
                }
                this.m_value = bitSet;
                this.m_value_num_bits += bERBitString.getSize();
            }
            n -= nArray2[0];
        }
    }

    public BERBitString(InputStream inputStream, int[] nArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = BERElement.readLengthOctets(inputStream, nArray);
        int n5 = inputStream.read();
        nArray[0] = nArray[0] + 1;
        this.m_value_num_bits = (--n4 - 1) * 8 + (8 - n5);
        this.m_value = new BitSet();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4 - 1) {
            n3 = inputStream.read();
            n2 = 128;
            n = 0;
            while (n < 8) {
                if ((n3 & n2) > 0) {
                    this.m_value.set(n6);
                } else {
                    this.m_value.clear(n6);
                }
                ++n6;
                n2 /= 2;
                ++n;
            }
            ++n7;
        }
        n3 = inputStream.read();
        n2 = 128;
        n = 0;
        while (n < 8 - n5) {
            if ((n3 & n2) > 0) {
                this.m_value.set(n6);
            } else {
                this.m_value.clear(n6);
            }
            ++n6;
            n2 /= 2;
            ++n;
        }
        nArray[0] = nArray[0] + n4;
    }

    public void write(OutputStream outputStream) throws IOException {
        int n;
        int n2;
        int n3;
        outputStream.write(3);
        int n4 = this.m_value_num_bits;
        int n5 = 8 - n4 % 8;
        int n6 = n4 / 8 + 1;
        if (n5 > 0) {
            ++n6;
        }
        outputStream.write(n6);
        outputStream.write(n5);
        int n7 = 0;
        while (n7 < n4 / 8) {
            n3 = 0;
            n2 = 128;
            n = 0;
            while (n < 8) {
                if (this.m_value.get(n7 * 8 + n)) {
                    n3 += n2;
                }
                n2 /= 2;
                ++n;
            }
            outputStream.write(n3);
            ++n7;
        }
        if (n5 > 0) {
            n3 = 0;
            n2 = 128;
            n = 0;
            while (n < n5) {
                if (this.m_value.get(n4 / 8 * 8 + n)) {
                    n3 += n2;
                }
                n2 /= 2;
                ++n;
            }
            outputStream.write(n3);
        }
    }

    public BitSet getValue() {
        return this.m_value;
    }

    public int getSize() {
        return this.m_value_num_bits;
    }

    public int getType() {
        return 3;
    }

    public String toString() {
        int n;
        int n2;
        int n3;
        String string = "";
        int n4 = this.m_value_num_bits;
        int n5 = 0;
        while (n5 < n4 / 8) {
            n3 = 0;
            n2 = 128;
            n = 0;
            while (n < 8) {
                if (this.m_value.get(n5 * 8 + n)) {
                    n3 += n2;
                }
                n2 /= 2;
                ++n;
            }
            string = String.valueOf(string) + " " + (byte)n3;
            ++n5;
        }
        n2 = 128;
        n3 = 0;
        n = 0;
        while (n < n4 - n4 / 8) {
            if (this.m_value.get(n4 / 8 * 8 + n)) {
                n3 += n2;
            }
            n2 /= 2;
            ++n;
        }
        string = String.valueOf(string) + " " + (byte)n3;
        return "Bitstring {" + string + " }";
    }
}

