/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Event;
import netscape.application.RootView;

public class MouseEvent
extends Event {
    public int x;
    public int y;
    int clickCount;
    int modifiers;
    public static final int MOUSE_DOWN = -1;
    public static final int MOUSE_DRAGGED = -2;
    public static final int MOUSE_UP = -3;
    public static final int MOUSE_ENTERED = -4;
    public static final int MOUSE_MOVED = -5;
    public static final int MOUSE_EXITED = -6;

    public MouseEvent() {
    }

    public MouseEvent(long l, int n, int n2, int n3, int n4) {
        this();
        this.timeStamp = l;
        if (n < -6 || n > -1) {
            throw new IllegalArgumentException("Invalid MouseEvent type: " + n);
        }
        this.type = n;
        this.x = n2;
        this.y = n3;
        this.modifiers = n4;
    }

    public void setClickCount(int n) {
        this.clickCount = n;
    }

    public int clickCount() {
        return this.clickCount;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public boolean isShiftKeyDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlKeyDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaKeyDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isAltKeyDown() {
        return (this.modifiers & 8) != 0;
    }

    public void setRootView(RootView rootView) {
        this.processor = rootView;
    }

    public RootView rootView() {
        return (RootView)this.processor;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case -1: {
                string = "Down";
                break;
            }
            case -2: {
                string = "Dragged";
                break;
            }
            case -3: {
                string = "Up";
                break;
            }
            case -4: {
                string = "Entered";
                break;
            }
            case -5: {
                string = "Moved";
                break;
            }
            case -6: {
                string = "Exited";
                break;
            }
            default: {
                string = "Unknown Type";
            }
        }
        return "MouseEvent: " + string + " at: (" + this.x + "," + this.y + ")" + " modifiers: " + this.modifiers + " clicks: " + this.clickCount;
    }
}

