/*
 *   meioaddr.h -- MEIO driver interface definitions
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/*------------------------------------------------------------------------*/
/* define MEIOD Device Driver Interface Contants                          */
/*------------------------------------------------------------------------*/
#define MEIO_SYS_BAD_FUNCTION 0x0001      /* BAD IDC or IOCTL function cd */

/*------------------------------------------------------------------------*/
/* define IOCTL / IDC Interface macro                                     */
/*------------------------------------------------------------------------*/

ULONG meiowinIOCTL(UINT wMessage,LPARAM lParam1);

#define MEIO_IOCTL(hdev,fn,requestblk,reqblkszv)                           \
   (1==meiowinIOCTL( fn+DRV_RESERVED                    /* UINT message  */\
                    ,(LPARAM)((void FAR *)&requestblk)))/* LPARAM lParam1*/\

/*------------------------------------------------------------------------*/
/* MeioAPIDispatch()                                                      */
/*------------------------------------------------------------------------*/
APIRET APIENTRY MeioAPIDispatch(  /* function to dispatch IDC or IOCTL */
                                     /* to MEIO core code.                */
          USHORT         usFunction, /* IDC function to perform           */
          VOID FARPTR16  fp16Args);  /* Function Arguments                */

/*------------------------------------------------------------------------*/
/* declare IOCTL parameter blocks                                         */
/*------------------------------------------------------------------------*/


/*------------------------------------------------------------------------*/
/* MEIO Generic Parameter Block                                       CH01*/
/*------------------------------------------------------------------------*/
typedef struct                                                      /*CH01*/
{                                                                   /*CH01*/
   ULONG          ulRC;     /* function return code (always required) CH01*/
} MEIO_IOCTL_GENERIC_PARMS;                                         /*CH01*/


/*------------------------------------------------------------------------*/
/* MEIO OPEN API                                                          */
/*------------------------------------------------------------------------*/
typedef struct
{
   ULONG          ulRC;      /* function return code              */
   HDSP           hDsp;      /* Handle of DSP device from DSPMGR  */
   HMEIO FARPTR16 phMeio;    /* Handle of MEIO Instance returned  */
   ULONG          ulOptions; /* reserved - must be 0              */
} MEIO_IOCTL_OPEN_PARMS;


/*------------------------------------------------------------------------*/
/* MEIO CLOSE API                                                         */
/*------------------------------------------------------------------------*/
typedef struct
{
   ULONG          ulRC;      /* function return code              */
   HMEIO          hMeio;     /* Handle of MEIO Instance returned  */
                             /*           by dspMeioOpen()        */
   ULONG          ulOptions; /* reserved - must be 0              */
} MEIO_IOCTL_CLOSE_PARMS;



/*------------------------------------------------------------------------*/
/* MEIO QUERY API                                                         */
/*------------------------------------------------------------------------*/
typedef struct
{ ULONG          ulRC;           /* function return code    */
  HMEIO          hMeio;          /* MEIO Handle             */
  short          sRequest;
  ULONG FARPTR16 fp16Buffersize;
  VOID  FARPTR16 fp16Buffer;
} MEIO_IOCTL_QUERYAB_PARMS;


/*------------------------------------------------------------------------*/
/* MEIO CONNECT API                                                       */
/*------------------------------------------------------------------------*/
typedef struct
{ ULONG                ulRC;           /* function return code    */
  HMEIO                hMeio;          /* MEIO Handle               */
  HCONNECTION FARPTR16 fp16Connection; /* THE Connection is returned*/
  ULONG                OwnerPort;      /* Connection Owner          */
  ULONG                UserPort;       /* Connection User           */
  ULONG                SharingOptions; /* willingness to share      */
  ULONG                ulState;        /* set switch to this state  CH02 */
  ULONG                Reserved;       /* reserved - must be 0      */
} MEIO_IOCTL_CONNECT_PARMS;


/*------------------------------------------------------------------------*/
/* MEIO DISCONNECT API                                                    */
/*------------------------------------------------------------------------*/
typedef struct
{ ULONG               ulRC;        /* function return code    */
  HCONNECTION         hConnection; /* handle returned by     */
                                   /* dspMeioConnect()       */
  ULONG               Reserved;    /* reserved, must be 0       CH02*/
} MEIO_IOCTL_DISCONNECT_PARMS;


/*------------------------------------------------------------------------*/
/* MEIO RESYNC API                                                    CH01*/
/*------------------------------------------------------------------------*/
typedef struct                                                      /*CH01*/
{ ULONG               ulRC;        /* function return code   */     /*CH01*/
  short               sObjectType; /* type of handle being passed*/
  ULONG               Object;      /* some Mwave handle          */
                                   /* dspMeioConnect()           */
  ULONG               ulOptions;   /* resync options, must be 0  */
} MEIO_IOCTL_RESYNC_PARMS;                                          /*CH01*/


/*------------------------------------------------------------------------*/
/* MEIO Update Connection Attributes                                      */
/*------------------------------------------------------------------------*/
typedef struct
{
  ULONG                 ulRC;         /* function return code           */
  HCONNECTION           hConnection;  /* handle returned by             */
                                      /* dspMeioConnect()               */
  short                 sAttribute;   /* define attribute to update.    */
  LONG                  lValue;       /* value of attribute.            */
} MEIO_IOCTL_UPDATECON_PARMS;


/*------------------------------------------------------------------------*/
/* MEIO Query Connection Attributes                                       */
/*------------------------------------------------------------------------*/
typedef struct
{
  ULONG                 ulRC;         /* function return code           */
  HCONNECTION           hConnection;  /* handle returned by             */
                                      /* dspMeioConnect()               */
  short                 sAttribute;   /* define attribute to update.    */
  LONG      FARPTR16    fp16lValue;   /* value of attribute.            */
} MEIO_IOCTL_QUERYCON_PARMS;

// @PORT int pascal InitializeMEIO( char FAR *lpszCmdLine );
int InitializeMEIO( char FAR *lpszCmdLine ); // @PORT
void       MEIOrestart(void);
void       MEIOstop(void);

#define MEIO_IOCtl_Restart (MEIO_IOCtl_Resync+16)
#define MEIO_IOCtl_Stop    (MEIO_IOCtl_Resync+17)

