/*
 *   port_functions.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#ifndef _PORT_FUNCTIONS
#define _PORT_FUNCTIONS

#undef min
#define min(a,b) ((a) < (b) ? (a) : (b))

void    DPF(char *szFormat, ...);

UINT GetPrivateProfileInt( LPCTSTR lpAppName, // section name
		LPCTSTR lpKeyName, // key name
		INT nDefault, // return value if key name not found
		LPCTSTR lpFileName // initialization file name
		);

DWORD GetPrivateProfileString( LPCTSTR lpAppName, // section name
		LPCTSTR lpKeyName, // key name
		LPCTSTR lpDefault, // default string
		LPTSTR lpReturnedString, // destination buffer
		DWORD nSize, // size of destination buffer
		LPCTSTR lpFileName // initialization file name
		);

DWORD WritePrivateProfileString(LPCTSTR lpAppName,
				LPCTSTR lpKeyName,
				LPCTSTR lpString,
				LPCTSTR lpFileName);
#include <sys/syslog.h>
#define MW_TRACE
extern DWORD modem_trc_flags;

#define TRACE_MANAGER_API       0x00000001
#define TRACE_MANAGER_API_DATA  0x00000002
#define TRACE_MANAGER_CORE      0x00000004
#define TRACE_MANAGER_SPECIFIC  0x00000008
#define TRACE_MEIO_API          0x00000010
#define TRACE_MEIO_CORE         0x00000020
#define TRACE_MEIO_SPECIFIC     0x00000040
#define TRACE_MWMLW32           0x00000100
#define TRACE_MWMLW32_ERROR     0x00000200
#define TRACE_MWMPW32           0x00000400
#define TRACE_MWMUTIL           0x00000800
#define TRACE_MWWTT32           0x00001000
#define TRACE_MWMBL             0x00002000

#define MW_SYSLOG_ERROR syslog

#ifdef MW_TRACE
#define MW_SYSLOG_1(f,s)                   \
  if (f & (modem_trc_flags)) {                \
    syslog(LOG_INFO,s);                    \
  }

#define MW_SYSLOG_2(f,s,v1)                \
  if (f & (modem_trc_flags)) {                \
    syslog(LOG_INFO,s,v1);                 \
  }

#define MW_SYSLOG_3(f,s,v1,v2)             \
  if (f & (modem_trc_flags)) {                \
    syslog(LOG_INFO,s,v1,v2);              \
  }

#define MW_SYSLOG_4(f,s,v1,v2,v3)          \
  if (f & (modem_trc_flags)) {                \
    syslog(LOG_INFO,s,v1,v2,v3);           \
  }

#define MW_SYSLOG_5(f,s,v1,v2,v3,v4)       \
  if (f & (modem_trc_flags)) {                \
    syslog(LOG_INFO,s,v1,v2,v3,v4);        \
  }

#define MW_SYSLOG_6(f,s,v1,v2,v3,v4,v5)    \
  if (f & (modem_trc_flags)) {                \
    syslog(LOG_INFO,s,v1,v2,v3,v4,v5);     \
  }

#define MW_SYSLOG_7(f,s,v1,v2,v3,v4,v5,v6) \
  if (f & (modem_trc_flags)) {                \
    syslog(LOG_INFO,s,v1,v2,v3,v4,v5,v6);  \
  }

#else
#define MW_SYSLOG_1(s)    
#define MW_SYSLOG_2(s,v1)
#define MW_SYSLOG_3(s,v1,v2)              
#define MW_SYSLOG_4(s,v1,v2,v3)           
#define MW_SYSLOG_5(s,v1,v2,v3,v4)        
#define MW_SYSLOG_6(s,v1,v2,v3,v4,v5)     
#define MW_SYSLOG_7(s,v1,v2,v3,v4,v5,v6)  
#endif

#endif

