/*
 *   mwcload.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/***********************************************************************************************/


#pragma pack(4)


/*
 *  Error codes
 */
#define MWCLERROR_BASE                          0x20000000L
#define MWCLERROR_NoError                       0L
#define MWCLERROR_ApiNotEnabled                 (MWCLERROR_BASE + 0x00000001L)
#define MWCLERROR_InvalidSubsystemId            (MWCLERROR_BASE + 0x00000002L)
#define MWCLERROR_InvalidApplicationId          (MWCLERROR_BASE + 0x00000003L)
#define MWCLERROR_OutOfMemory                   (MWCLERROR_BASE + 0x00000004L)
#define MWCLERROR_InternalError                 (MWCLERROR_BASE + 0x00000005L)
#define MWCLERROR_UnsupportedApiVersion         (MWCLERROR_BASE + 0x00000006L)
#define MWCLERROR_CantAccessMwclData            (MWCLERROR_BASE + 0x00000007L)
#define MWCLERROR_UnsupportedRequest            (MWCLERROR_BASE + 0x00000008L)
#define MWCLERROR_OutOfSubsystems               (MWCLERROR_BASE + 0x00000009L)
#define MWCLERROR_OutOfApplications             (MWCLERROR_BASE + 0x0000000AL)
#define MWCLERROR_CantCreateSubsystemProcess    (MWCLERROR_BASE + 0x0000000BL)
#define MWCLERROR_CantLoadApplicationModule     (MWCLERROR_BASE + 0x0000000CL)
#define MWCLERROR_CantCreateApplicationThread   (MWCLERROR_BASE + 0x0000000DL)
#define MWCLERROR_CantSubmitSubsystemRequest    (MWCLERROR_BASE + 0x0000000EL)
#define MWCLERROR_NoApplicationEntryPoint       (MWCLERROR_BASE + 0x0000000FL)
#define MWCLERROR_InvalidControlProcPtr         (MWCLERROR_BASE + 0x00000010L)



/*
 *  Miscellaneous constants
 */
#define MWCL_ApiVersion                 0xFF000001L
#define MWCL_MaxNameSize                32
#define MWCL_MaxDescriptionSize         64    
#define MWCL_MaxFilePathSize            260
#define MWCL_MaxCmdLineSize             128



/*
 *  Commands code constants for application and service control procedures
 */
#define MWCL_CProcCmd_NoOp              0x00000000L
#define MWCL_CProcCmd_QueryExit         0x00000001L
#define MWCL_CProcCmd_Exit              0x00000002L
#define MWCL_CProcCmd_PowerEvent        0x00000003L
#define MWCL_CProcCmd_DumpState         0x00000004L
#define MWCL_CProcCmd_EnumerateMsgs     0x00000005L
#define MWCL_CProcCmd_ProcessMsg        0x00000006L



/*
 *  Result code constants for application and service control procedures
 */
#define MWCL_CProcRes_Success           0x00000000L
#define MWCL_CProcRes_Fail              0x00000001L
#define MWCL_CProcRes_Unsupported       0x00000002L



/*
 *  Miscellaneous constants for application and service control procedures
 */
#define MWCL_PowerState_Suspend         0x00000000L
#define MWCL_PowerState_Resume          0x00000001L



/*
 *  Application entry point constants
 */
#define MWCL_Entry_Rel2MainEntry        "Rel2MainEntry"
#define MWCL_Entry_MwaveAppletMain      "MwaveAppletMain"



/*
 *  Types
 */
typedef unsigned ( * PFN_MwclControlProc)( unsigned /* uCommand */, void * /* pvArgs */);

typedef struct {
    unsigned uApiVersion;                                   // Version ID of structure (in)
    unsigned uSubsystemId;                                  // Subsystem identifier (out)
    char szName[MWCL_MaxNameSize];                          // Friendly-name of subsystem (out)
    char szDescription[MWCL_MaxDescriptionSize];            // Description of this subsystem (out)
    char szFilePath[MWCL_MaxFilePathSize];                  // Fully-qualified name of path to subsystem EXE (out)
    char szCmdLine[MWCL_MaxCmdLineSize];                    // Command line passed to subsystem (out)
    char szSubsystemDir[MWCL_MaxFilePathSize];              // Subsystem directory (the initial current directory) (out)
    unsigned uAppCount;                                     // Count of applications loaded into subsystem (out)
    unsigned uServiceCount;                                 // Count of services loaded into subsystem (out)
} MWCL_rSubsystemData;

typedef struct {
    unsigned uApiVersion;                                   // Version ID of structure (in)
    unsigned uApplicationId;                                // Application identifier (out)
    char szName[MWCL_MaxNameSize];                          // Friendly-name of application (out)
    char szDescription[MWCL_MaxDescriptionSize];            // Description of this application (out)
    char szFilePath[MWCL_MaxFilePathSize];                  // Fully-qualified name of path to application (out)
    char szCmdLine[MWCL_MaxCmdLineSize];                    // Command line passed to application (out)
    char szAppDir[MWCL_MaxFilePathSize];                    // Application directory (the initial current directory) (out)
    PFN_MwclControlProc pfnControlProc;                     // Pointer to control procedure for application (out)
} MWCL_rApplicationData;

typedef struct {
    unsigned uApiVersion;                                   // Version ID of structure (in)
    unsigned uCreateFlags;                                  // Creation flags (in) (must be zero, for now)
    char szName[MWCL_MaxNameSize];                          // Friendly-name of subsystem (in)
    char szDescription[MWCL_MaxDescriptionSize];            // Description of this subsystem (in)
    char szFilePath[MWCL_MaxFilePathSize];                  // Fully-qualified name of path to subsystem executable (in)
    char szCmdLine[MWCL_MaxCmdLineSize];                    // Command line passed to subsystem (in)
    char szSubsystemDir[MWCL_MaxFilePathSize];              // Directory to become the current directory for the process (in)
    unsigned uNewId;                                        // New subsystem identifier (out)
} MWCL_rCreateSubsystemParms;

typedef struct {
    unsigned uApiVersion;                                   // Version ID of structure (in)
    unsigned uTerminateFlags;                               // Termination flags (in) (must be zero, for now)
    unsigned uSubsystemId;                                  // Subsystem identifier (in)
} MWCL_rTerminateSubsystemParms;

typedef struct {
    unsigned uApiVersion;                                   // Version ID of structure (in)
    unsigned uLoadFlags;                                    // Load flags (in) (must be zero, for now)
    char szName[MWCL_MaxNameSize];                          // Friendly-name of application (in)
    char szDescription[MWCL_MaxDescriptionSize];            // Description of this application (in)
    char szFilePath[MWCL_MaxFilePathSize];                  // Fully-qualified name of path to application LIB (in)
    char szCmdLine[MWCL_MaxCmdLineSize];                    // Command line passed to application (in)
    char szAppDir[MWCL_MaxFilePathSize];                    // Directory to become the current directory for the thread (in)
    unsigned uSubsystemId;                                  // Subsystem identifier (in)
    unsigned uNewId;                                        // New application identifier (out)
} MWCL_rLoadAppParms;            

typedef struct {
    unsigned uApiVersion;                                   // Version ID of structure (in)
    unsigned uUnloadFlags;                                  // Unload flags (in) (must be zero, for now)
    unsigned uApplicationId;                                // Application identifier (in)
} MWCL_rUnloadAppParms;

typedef struct {
    char * pszCmdLine;                                      // Pointer to command line argument (in)
    char * pszAppDir;                                       // Application directory (not necessarily the file path) (in)
    HINSTANCE hInstance;                                    // Application instance (in)
    unsigned uSubsystemId;                                  // ID of the subsystem in which the application is running (in)
    unsigned uApplicationId;                                // ID of the application (in)
    HANDLE   hApplicationThread;                            // Handle of this application's initial thread (in)
} MWCL_rMwaveAppletMain;

typedef struct {
    char * pszCmdLine;                                      // Pointer to command line argument (in)
    char * pszServiceDir;                                   // Service directory (not necessarily the file path) (in)
    HINSTANCE hInstance;                                    // Service instance (in)
    unsigned uSubsystemId;                                  // ID of the subsystem in which the service is running (in)
    unsigned uServiceId;                                    // ID of the service (in)
} MWCL_rMwaveServiceInit;

typedef struct {
    BOOL bSafeToExit;                                       // Set to TRUE if it is safe to exit the application (out)
} MWCL_rCProc_QueryExitParms;

typedef struct {
    unsigned uPowerState;                                   // Power state to which we are transitioning (in)
} MWCL_rCProc_PowerEventParms;

typedef BOOL ( * PFN_Rel2MainEntry)( char * );
typedef BOOL ( * PFN_MwaveAppletMain)( MWCL_rMwaveAppletMain * );
typedef BOOL ( * PFN_MwaveServiceInit)( MWCL_rMwaveServiceInit * );



/*
 *  Functions
 */
ULONG mwclStartSubsystem( char * pszSubsystemId );
ULONG mwclCreateSubsystem( MWCL_rCreateSubsystemParms * pCreateParms );
ULONG mwclTerminateSubsystem( MWCL_rTerminateSubsystemParms *pTerminateParms );
ULONG mwclLoadApplication( MWCL_rLoadAppParms * pLoadParms );
ULONG mwclUnloadApplication( MWCL_rUnloadAppParms *pUnloadParms );
ULONG mwclGetSubsystemCount( unsigned * puSubsystemCount );
ULONG mwclEnumBasicSubsystemData( unsigned uSubsystemId, MWCL_rSubsystemData * pSubsystemData );
ULONG mwclEnumBasicApplicationData( unsigned uApplicationId, unsigned uSubsystemId, MWCL_rApplicationData * pApplicationData );
ULONG mwclRegisterAppControlProc( unsigned uApplicationId, PFN_MwclControlProc pControlProc );
ULONG mwclUnregisterAppControlProc( unsigned uApplicationId );
ULONG mwclRegisterServiceControlProc( unsigned uServiceId, PFN_MwclControlProc pControlProc );
ULONG mwclUnregisterServiceControlProc( unsigned uServiceId );
ULONG mwclRegisterServiceControlProcXMgr( PFN_MwclControlProc pControlProc ); // Temp version of functions
ULONG mwclRegisterServiceControlProcX( PFN_MwclControlProc pControlProc );  // Temp version of functions
ULONG mwclUnregisterServiceControlProcX( PFN_MwclControlProc pControlProc ); // Temp version of functions
ULONG mwclRegisterServiceControlProc( unsigned uServiceId, PFN_MwclControlProc pControlProc );
ULONG mwclUnregisterServiceControlProc( unsigned uServiceId );
ULONG mwclBroadcastPowerEvent( unsigned uSubsystemId, unsigned uPowerState, BOOL bHeadToTail );

#pragma pack()


/************************** Mark end of extern "C" block if using C++ **************************/
/***********************************************************************************************/
