/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __UTIL_H__
#define __UTIL_H__

char *floaterstrcat(char *, char *);
char *tempcat(char *, char *);

#define STRDUP(s) floaterstrdup(s)
#define TEMPCOPY(s) markgarbage(STRDUP(s))

/* Duplicate a string, copying at most N characters; always null terminate and 
   always allocate N+1 characters. */
#define STRNDUP(s, N) (nstrncpy(salloc(((N) + 1) * sizeof(char)), (s), (N)))

#define STRCPY(dest, src) { assert(strlen(src) < sizeof(dest)); \
			      strcpy(dest, src); }
#define STRCAT(a, b) floaterstrcat(STRNDUP((a), (strlen(a) + strlen(b))), (b))
#define STRCAT4(a, b, c, d) floaterstrcat(floaterstrcat(floaterstrcat(STRNDUP((a), (strlen(a) + strlen(b) + strlen(c) + strlen(d))), (b)), (c)), (d))
#define TEMPCAT(a, b) markgarbage(floaterstrcat(STRNDUP((a), (strlen(a) + strlen(b))), (b)))
#define TEMPCAT3(a, b, c) markgarbage(floaterstrcat(floaterstrcat(STRNDUP((a), (strlen(a) + strlen(b) + strlen(c))), (b)), (c)))
#define TEMPCAT4(a, b, c, d) markgarbage(STRCAT4(a, b, c, d))

/* copy at most n characters; always null terminate (so s1 may get
   n characters and then a null) */
char *nstrncpy(char *s1, char *s2, int n);

char *trim(char *s);
char *gstrcpy(char *s1, char *s2);
int lastnum(char *s);
int lastnumslash(char *s);
int maxnumslash(char *s);
bool parsebool(char *s, bool *b);
int parseint(char **s);
char *destructiveBackslashToSlash(char *s);
#define itoa floater_itoa
char *itoa(int n);
char *dtoa(double f);
char *upcase(char *name);
char *downcase(char *name);
char *strncpy2(char *dest, char *src, int n);
char *floaterstrdup(char *s);
bool strcaseeq(char *s, char *t); /* string compare ignoring case */
char *maybe_plural(char *num, char *thing);
char *nextword(char **s);
/* int strncasecmp(char *s1, char *s2, int n); */

#define strncpy3(dest, src) strncpy2((dest), (src), sizeof(dest) - 1)

#define max(a, b) (((a) > (b)) ? (a) : (b))
#define min(a, b) (((a) < (b)) ? (a) : (b))
#define max3(a, b, c) max(max(a, b), c)
#define max4(a, b, c, d) max(max(a, b), max(c, d))

#define reset(x) ((x) == NULL ? NULL : (free(x), ((x) = NULL)))

/* do nothing for x milliseconds */
#define sleep(x) TclDo2("after ", itoa(x))

/* returns whether the given string is a numeral */
#define isnumeral(s) atob(TclDo3("regexp {^[ ]*(-)?[0-9]+[ ]*$} {", (s), "}"))
#define isnumeralf(s) atob(TclDo3("regexp {^[ ]*(-)?[0-9]+([.][0-9]*)?[ ]*$} {", (s), "}"))

#define charindex(c, s) (strchr(s, c) - s)
#define char_to_rank(c) charindex(toupper(c), card_to_char)

#define strexists(s) ((s) != NULL && (*(s)) != '\0')

#define safestreq(a, b) ((a) != NULL && (b) != NULL && streq((a), (b)))

#endif
