# Copyright (c) 1996--1999 Geoff Pike. 
# All rights reserved. 

# Floater is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 

# This software is provided "as is" and comes with absolutely no 
# warranties.  Geoff Pike is not liable for damages under any 
# circumstances.  Support is not provided.  Use at your own risk. 

# Personal, non-commercial use is allowed.  Attempting to make money 
# from Floater or products or code derived from Floater is not allowed 
# without prior written consent from Geoff Pike.  Anything that remotely 
# involves commercialism, including (but not limited to) systems that 
# show advertisements while being used and systems that collect 
# information on users that is later sold or traded require prior 
# written consent from Geoff Pike. 
proc clearrect {x y} {}
proc anchor {l} {}
proc down_and_anchor {{l 1}} {}
proc right {{l 1}} {}
proc str {l} {}
proc ch {l} {}

#############################################################################

proc gotresult {setname handname} {
    global sets
    set sets($setname) 1
    global hands_$setname
    set hands_$setname\($handname) 1
}

gset months {Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec}

proc parseset {setname} {
    global setdate setday setmonth setyear months setscoremethod

    regexp {([0-9]+)([a-zA-Z]+)([0-9]+)(.*)} $setname all \
	    setday setmonth setyear setscoring
    set setdate "$setday$setmonth$setyear"
    set setmonth [lsearch $months $setmonth]
    if {$setscoring == "IMP"} {set setscoremethod 0} {set setscoremethod 1}
}

# convert two-digit year into "real" year
proc yearadjust {y} {
    if {$y < 96} {expr $y + 2000} {expr $y + 1900}
}

proc setsort {a b} {
    global months

    regexp {([0-9]+)([a-zA-Z]+)([0-9]+)(.*)} $a all aday amonth ayear ascore
    regexp {([0-9]+)([a-zA-Z]+)([0-9]+)(.*)} $b all bday bmonth byear bscore
    if {$ayear != $byear} \
	    {return [expr [yearadjust $ayear] - [yearadjust $byear]]}
    set amonth [lsearch $months $amonth]
    set bmonth [lsearch $months $bmonth]
    if {$amonth != $bmonth} {return [expr $amonth - $bmonth]}
    if {$aday != $bday} {return [expr $aday - $bday]}
    string compare $ascore $bscore
}
    
gset sets_sorted ""
proc firstset {} {
    global setiter sets sets_sorted

    if {$sets_sorted == ""} {
	set sets_sorted \
		[lsort -command setsort -decreasing [array names sets]]
    }
    set setiter $sets_sorted
    nextset
}

proc nextset {} {
    global setiter

    if {$setiter == ""} return ""
    set r [lindex $setiter 0]
    set setiter [lrange $setiter 1 end]
    return $r
}

proc gotnames {e w n s} {
    global names

    set names($n) 1
    set names($s) 1
    set names($e) 1
    set names($w) 1
}
    
proc nsort_ {a b} {
    string compare [string toupper $a] [string toupper $b]
}

proc nsort {l} {
    lsort -command nsort_ $l
}

gset names_sorted ""
proc firstname {} {
    global nameiter names_sorted names

    if {$names_sorted == ""} {set names_sorted [nsort [array names names]]}
    set nameiter $names_sorted
    nextname
}

proc nextname {} {
    global nameiter

    if {$nameiter == ""} return ""
    set r [lindex $nameiter 0]
    set nameiter [lrange $nameiter 1 end]
    return $r
}

proc firstsubname {first last} {
    global nameiter names_sorted names subdone namesublast

    if {$names_sorted == ""} {set names_sorted [nsort [array names names]]}
    set nameiter $names_sorted
    while {"[nextname]" != "$first"} {}
    set subdone 0
    set namesublast $last
    return $first
}

proc nextsubname {} {
    global nameiter subdone namesublast

    if $subdone {return ""}
    set r [lindex $nameiter 0]
    set nameiter [lrange $nameiter 1 end]
    if {$r == $namesublast} {set subdone 1}
    return $r
}

proc firsthand {s} {
    global handiter hands_$s

    set handiter [array names hands_$s]
    nexthand
}

proc nexthand {} {
    global handiter

    if {$handiter == ""} return ""
    set r [lindex $handiter 0]
    set handiter [lrange $handiter 1 end]
    return $r
}
###########################################################################
proc maxcol {} {
    upvar COL col
    global maxrow

    set maxcol 0
    set maxrow 0
    foreach z [array names col] {
	if {[lindex [set s [split $z ,]] 1] > $maxrow} \
		{set maxrow [lindex $s 1]}
	if {[lindex $s 0] > $maxcol} \
		{set maxcol [lindex $s 0]}
    }
    return $maxcol
}

proc colget {i j} {
    upvar COL col

    if [info exists col($i,$j)] {
	set r $col($i,$j)
	unset col($i,$j)
	return $r
    } else {
	return " "
    }
}

