/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
/* 
 *	main.c
 */

#include <stdio.h>
#include <tcl.h>
#include <tk.h>
#include "floater.h"
#include "debug.h"
#include "tickler.h"
#include "commandhash.h"
#include "comm.h"
#ifdef WIN32
#include "maximize.h"
#include "shortcut.h"
#endif

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

#if LOGGING||MAKING_TUTORIAL
FILE *logfile;
#endif

#if 0
extern int matherr();
int *tclDummyMathPtr = (int *) matherr;
#endif

Tcl_Interp *interp;		/* Interpreter for this application. */

/* default is to use X, if available */
bool usingTk = TRUE;
bool using_curses = FALSE;

bool geometry_specified = FALSE;
bool initializing = TRUE;

char *platform = NULL; /* String describing machine, OS, etc. */

#ifdef WIN32
extern void create_shortcut(char *destfile, char *linkfile,
			    char *icon, char *desc);
#define do_shortcut() create_shortcut(getenv("short_dest"),	\
				      getenv("short_link"),	\
				      getenv("short_icon"),	\
				      getenv("short_desc"))

#endif /* WIN32 */

int Floater(Tcl_Interp *i)
{
  extern void destroygarbage(void);
#ifdef WIN32
  bool make_shortcut = strexists(getenv("short_link"));
  if (make_shortcut)
    usingTk = FALSE;
#endif

  interp = i;

  if (Tcl_Init(i) == TCL_ERROR) {
    fatal(GET_INTERP_RESULT(), 2);
  }

#if NO_TK || SILENT
  usingTk = FALSE;
#else
  if (usingTk && (Tk_Init(i) == TCL_ERROR)) {
    fputs(GET_INTERP_RESULT(), stderr);
    usingTk = FALSE;
  }
#endif /* NO_TK||SILENT */

#ifdef WIN32
  if (make_shortcut) {
    do_shortcut();
    exit(0);
  }
#endif

  if (GUI_ONLY && !usingTk) {
    fatal(GET_INTERP_RESULT(), 1);
  }

#if !SILENT && !NO_TK
  Tcl_StaticPackage(i, "Tk", Tk_Init, (Tcl_PackageInitProc *) NULL);
#endif

  check_library_paths();

#ifdef WIN32
  Tcl_CreateCommand(i, "maximize", maximize_window, (ClientData) NULL,
		    (Tcl_CmdDeleteProc *) NULL);
  TclDo("maximize .");
#endif
  Tcl_CreateCommand(i, "commandn", floaterentrypoint, (ClientData) cmd,
		    (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(i, "floaterreceiven", floaterentrypoint,
		    (ClientData) receivemessage, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(i, "FloaterClosen", floaterentrypoint,
		    (ClientData) FloaterClose, (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(i, "floatertimeoutn", floaterentrypoint,
		    (ClientData) floatertimeout, (Tcl_CmdDeleteProc *) NULL);

#if 0
  Tcl_CreateCommand(i, "requestresultn", floaterentrypoint,
		    (ClientData) TCLreqresult, (Tcl_CmdDeleteProc *) NULL);
#endif

  Tcl_CreateCommand(i, "talkn", floaterentrypoint, (ClientData) talk,
		    (Tcl_CmdDeleteProc *) NULL);

#if !GUI_ONLY && !SILENT
  if (!hasWindows) {
    Tcl_CreateCommand(i, "anchor", anchor, (ClientData) 0,
		      (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(i, "clearrect", clearrect, (ClientData) 0,
		      (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(i, "down_and_anchor", down_and_anchor,
		      (ClientData) 0, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(i, "right", right, (ClientData) 0,
		      (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(i, "str", str, (ClientData) 0,
		      (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(i, "ch", ch, (ClientData) 0,
		      (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(i, "reset_cursor_position", reset_cursor_position,
		      (ClientData) 0, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(i, "draw_on_current_display",
		      draw_on_current_display,
		      (ClientData) 0, (Tcl_CmdDeleteProc *) NULL);
  }
#endif

  /* set up bindings used by the "command" tcl command --- see commandhash.c */
  setupbindings();

  inittickler();

  TclSet("geometry_specified", itoa(geometry_specified));

#if LOGGING||MAKING_TUTORIAL
  if (LOGGING || !hasWindows) {
    char s[80];
    
#if LOGGING
    sprintf(s, "log%s", TclDo("pid"));
#else
    strcpy(s, "tutlog.tcl");
#endif
    if ((logfile = fopen(s, "w")) == NULL) fatal("Unable to open logfile", 1);
  }      
#endif

  TclSet("floater_silent", SILENT ? "1" : "0");

#if !GUI_ONLY && !SILENT
  if (!hasWindows) {
    begincurses();
    raw();
    noecho();
    nonl();
    intrflush(stdscr, FALSE);
    keypad(stdscr, TRUE);

    /* porting note: if halfdelay() isn't available, try:
       nodelay(stdscr, TRUE);

       (but, our autoconf script already tries to get this right) */
#if USE_NODELAY
    nodelay(stdscr, TRUE);
#else
    halfdelay(1); /* wait 0.1 second for a keypress before timing out */
#endif

    if (LINES < 24 || COLS < 80) {
      fatal("You must have at least 24 rows and 80 columns to use Floater.",
	    1);
    }
    inittextio();
    source("floatert");
    textrefresh();
  }
#endif
  if (hasWindows) {
#ifndef SERVER
#include "bitmaps/bitmaps.c"
#endif
    source("floater");
  } else if (SILENT) {
    source("floatert");
  }

  TclDo2("uplevel #0 incr loginserverport ", itoa((int) FLOATER_VERSION[0]));

  platform = STRDUP(TclDo("uplevel #0 {catch {unset s}; foreach i [lsort [array names tcl_platform]] {lappend s $tcl_platform($i)}; return [join $s _]}"));

#ifdef LOGINSERVER
  source("ls");
#endif
#ifdef RESULTSERVER
  source("rs");
#endif
#ifdef PSEUDOMAILER
  source("pm");
#endif
#ifdef RES2HTML
  source("rs");
  source("res2html");
#else
  commsetup(); /* get local IP address, etc. */
#endif
  destroygarbage();
#ifdef SERVER  
  if (hasWindows) TclDo("catch {pack forget .play}");
#endif
#ifdef LOGINSERVER
  TclDo("command loginserver");
#endif
#ifdef RESULTSERVER
  TclDo("command resultserver");
#endif
#ifdef PSEUDOMAILER
  TclDo("command pseudomailer");
#endif
#ifdef RES2HTML
  res2html(); /* does not return */
#endif

  initializing = FALSE;
#if SILENT
  while (TRUE) Tcl_DoOneEvent(0);
#else
  if (hasWindows) {
    extern char *helpcommands;

    TclDo3("menus_helpcommands {", helpcommands, "}");
    Tk_MainLoop();
  }
#if !GUI_ONLY
  else
    {
      int snooze = 0;

      while (TRUE) {
	int c;
	extern void tasks(void);
	
	c = getch();
	if (c == ERR) {
	  if (++snooze > 5) { tasks(); snooze = 0; }
	  if (needrefresh) textrefresh();
	} else {
	  gotch(c);
	  destroygarbage();
	}
	(void)Tk_DoOneEvent(TK_DONT_WAIT);
      }
    }
#endif
#endif
  return 0; /* never reached */
}

#ifndef NO_MAIN
int main(int argc, char **argv)
{
  int i;

  /* if last character of argv[0] is t, use text version */
  if (argv[0][strlen(argv[0]) - 1] == 't') usingTk = FALSE;

  for (i = 0; i < argc; i++) {
    /* printf("argv[%d] = %s\n", i, argv[i]); */
    if (streq(argv[i], "-geometry")) geometry_specified = TRUE;
  }

#if SILENT || NO_TK
  Tcl_Main(argc, argv, Floater);
#else
  Tk_Main(argc, argv, Floater);
#endif
  return 99; /* not reached unless some catastrophic error prevents startup */
}
#endif /* NO_MAIN */
