/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __COMM_H__
#define __COMM_H__

#include "message.h"

void broadcast(message *m);
void selfmessage(message *m);

#ifdef LOGINSERVER
void loginserver(char *);
#else
void tablehost(char *, char *);
#endif

extern char *localIPaddr;
extern char *localIPaddr0;

extern bool tablehostmode;

/* used as last argument to join() */
#define NUMTRIES 1

/* number of tries when trying to connect to the result server */
#define NUMRSTRIES 1

void login(char *name, char *password, bool new);
int join(char *addr, char *port, char *capacity, int numtries);

void showip(void);
void showparent(void);
void showchildren(void);
void listwho(void);
char **getwho(int *n);
void gettables(void);
void changepw(char *name, char *old, char *new);

void sever_all_communication(void);

void commsetup();

char *outputname(char *name);

#ifndef SERVER
extern char location[200];
#endif

#define LIMBO 0
#define CONNECTED 2
#define DISCONNECTING 3

#define prioruse(name) atoi(TclDo3("global usedname; info exists {usedname(", name, ")}"))
#define setprioruse(name) TclDo3("setprioruse {", name, "}")

void sendmessage(char *to, message *m);
void requestseat(int which);

void commresult(bool competitive, message *m, char *handname);
void commseens(int delay);
void sendtoallchildren(message *m);

void describetable(char *note);
void redescribetable(void);

bool tableaddr(char *t, char *addr, char *port);

void checktablelisttimeouts(void);
void periodictablereannounce(void);

void try_rejoin(void);

#ifndef SERVER
void updatelocation(void);
#endif


/* stuff to handle spec */
#define no_spectators(hand) (spec = FALSE, TclDo3("catch {gunset is_spec", (hand), "}"))
#define make_spec(name, hand) (((hand) == NULL || (name) == NULL) ? NULL : \
	TclDo5("gset {is_spec", (hand), "(", (name), ")} 1"))
#define is_spec(name, hand) (((hand) == NULL || (name) == NULL) ? FALSE : \
	atob(TclDo5("global is_spec; info exists {is_spec", (hand), \
		    "(", (name), ")}")))

#endif

