#include "FireGLControl.h"
#include "watermark.xpm"
#include "atilogo.xpm"

InfoPage::InfoPage ( QWidget *parent, bool is_firegl ) : QWidget ( parent, (const char *)0 )
{
  m_Init = FALSE ;
  m_IsFireGL = is_firegl;
}

void InfoPage::Init ( )
{
  QLabel  *BInfo ;
  QLabel  *DInfo ;
  QLabel  *CardName, *BiosVersion, *ChipRevision ;
  QLabel  *MemorySize, *DriverVersion ;
  QLabel  *CardName1, *BiosVersion1, *ChipRevision1 ;
  QLabel  *MemorySize1, *DriverVersion1 ;
#ifdef FGLRX_OGL_INFO
  QLabel  *OGLInfo, *OGLVendor, *OGLVendor1, *OGLRenderer, *OGLRenderer1, *OGLVersion, *OGLVersion1;
#endif // FGLRX_OGL_INFO

  QLabel  *Logo ;
  QPixmap pixmap ( watermark ) ;
  QPixmap logopix ( atilogo ) ;
  setBackgroundPixmap ( pixmap ) ;

  const int col  = 140;
  const int col2 = 50;

 if( m_IsFireGL )
 {
  // ========
  BInfo = new QLabel ( tr("Display Adapter"), (QWidget *)this ) ;
//  BInfo->setFont (QFont( "Helvetica", 18 ) ) ;
  BInfo->setGeometry ( 10, 10, 300, 20 ) ;
  BInfo->setAutoResize ( TRUE ) ;
  BInfo->setBackgroundPixmap ( pixmap ) ;
  BInfo->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  BInfo->show ( ) ;

  CardName = new QLabel ( tr("Card Name :"), (QWidget *)this ) ;
  CardName->setGeometry ( 15, 35, 300, 20 ) ;
  CardName->setAutoResize ( TRUE ) ;
  CardName->setBackgroundPixmap ( pixmap ) ;
  CardName->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  CardName->show ( ) ;

  CardName1 = new QLabel ( BoardInfo.BoardName ( ), (QWidget *)this ) ;
  CardName1->setGeometry ( col, 35, 200, 20 ) ;
  CardName1->setAutoResize ( TRUE ) ;
  CardName1->setBackgroundPixmap ( pixmap ) ;
  CardName1->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  CardName1->show ( ) ;


  BiosVersion = new QLabel ( tr("BIOS Version :"), (QWidget *)this ) ;
  BiosVersion->setGeometry ( 20, 75, 300, 20 ) ;
  BiosVersion->setAutoResize ( TRUE ) ;
  BiosVersion->setBackgroundPixmap ( pixmap ) ;
  BiosVersion->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  BiosVersion->show ( ) ;

  BiosVersion1 = new QLabel ( BoardInfo.BiosVersion ( ), (QWidget *)this ) ;
  BiosVersion1->setGeometry ( col2, 95, 300, 20 ) ;
  BiosVersion1->setAutoResize ( TRUE ) ;
  BiosVersion1->setBackgroundPixmap ( pixmap ) ;
  BiosVersion1->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  BiosVersion1->show ( ) ;


  MemorySize = new QLabel ( tr("Memory Size :"), (QWidget *)this ) ;
  MemorySize->setGeometry ( 20, 55, 300, 20 ) ;
  MemorySize->setAutoResize ( TRUE ) ;
  MemorySize->setBackgroundPixmap ( pixmap ) ;
  MemorySize->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  MemorySize->show ( ) ;

  MemorySize1 = new QLabel ( BoardInfo.MemorySize ( ), (QWidget *)this ) ;
  MemorySize1->setGeometry ( col, 55, 300, 20 ) ;
  MemorySize1->setAutoResize ( TRUE ) ;
  MemorySize1->setBackgroundPixmap ( pixmap ) ;
  MemorySize1->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  MemorySize1->show ( ) ;
  }


#ifdef FGLRX_OGL_INFO
 if( m_IsFireGL )
 {
  // ========
  DInfo = new QLabel ( tr("Display Driver"), (QWidget *)this ) ;
//  DInfo->setFont (QFont( "Helvetica", 18 ) ) ;
  DInfo->setGeometry ( 10, 115, 300, 20 ) ;
  DInfo->setAutoResize ( TRUE ) ;
  DInfo->setBackgroundPixmap ( pixmap ) ;
  DInfo->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  DInfo->show ( ) ;

  DriverVersion = new QLabel ( tr("Driver Version :"), (QWidget *)this ) ;
  DriverVersion->setGeometry ( 20, 135, 300, 20 ) ;
  DriverVersion->setAutoResize ( TRUE ) ;
  DriverVersion->setBackgroundPixmap ( pixmap ) ;
  DriverVersion->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  DriverVersion->show ( ) ;

  DriverVersion1 = new QLabel ( BoardInfo.DriverVersion ( ), (QWidget *)this ) ;
  DriverVersion1->setGeometry ( col, 135, 300, 20 ) ;
  DriverVersion1->setAutoResize ( TRUE ) ;
  DriverVersion1->setBackgroundPixmap ( pixmap ) ;
  DriverVersion1->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  DriverVersion1->show ( ) ;
 }

  // ========
  OGLInfo = new QLabel ( tr("OpenGL:"), (QWidget *)this ) ;
//  OGLInfo->setFont (QFont( "Helvetica", 18 ) ) ;
  OGLInfo->setGeometry ( 10, 155, 300, 20 ) ;
  OGLInfo->setAutoResize ( TRUE ) ;
  OGLInfo->setBackgroundPixmap ( pixmap ) ;
  OGLInfo->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  OGLInfo->show ( ) ;

  OGLVendor = new QLabel ( tr("Vendor:"), (QWidget *)this ) ;
  OGLVendor->setGeometry ( 20, 175, 300, 20 ) ;
  OGLVendor->setAutoResize ( TRUE ) ;
  OGLVendor->setBackgroundPixmap ( pixmap ) ;
  OGLVendor->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  OGLVendor->show ( ) ;

  OGLVendor1 = new QLabel ( BoardInfo.OGLVendor ( ), (QWidget *)this ) ;
  OGLVendor1->setGeometry ( col, 175, 300, 20 ) ;
  OGLVendor1->setAutoResize ( TRUE ) ;
  OGLVendor1->setBackgroundPixmap ( pixmap ) ;
  OGLVendor1->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  OGLVendor1->show ( ) ;
  
  OGLRenderer = new QLabel ( tr("Renderer:"), (QWidget *)this ) ;
  OGLRenderer->setGeometry ( 20, 215, 300, 20 ) ;
  OGLRenderer->setAutoResize ( TRUE ) ;
  OGLRenderer->setBackgroundPixmap ( pixmap ) ;
  OGLRenderer->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  OGLRenderer->show ( ) ;

  OGLRenderer1 = new QLabel ( strtok ( strdup(BoardInfo.OGLRenderer ( )), "{[(" ),  (QWidget *)this ) ;
  OGLRenderer1->setGeometry ( col2, 235, 300, 20 ) ;
  OGLRenderer1->setAutoResize ( TRUE ) ;
  OGLRenderer1->setBackgroundPixmap ( pixmap ) ;
  OGLRenderer1->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  OGLRenderer1->show ( ) ;

  OGLVersion = new QLabel ( tr("Version:"), (QWidget *)this ) ;
  OGLVersion->setGeometry ( 20, 195, 300, 20 ) ;
  OGLVersion->setAutoResize ( TRUE ) ;
  OGLVersion->setBackgroundPixmap ( pixmap ) ;
  OGLVersion->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  OGLVersion->show ( ) ;

  OGLVersion1 = new QLabel ( BoardInfo.OGLVersion ( ), (QWidget *)this ) ;
  OGLVersion1->setGeometry ( col, 195, 300, 20 ) ;
  OGLVersion1->setAutoResize ( TRUE ) ;
  OGLVersion1->setBackgroundPixmap ( pixmap ) ;
  OGLVersion1->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  OGLVersion1->show ( ) ;

  // ========
  Logo = new QLabel ( "", (QWidget *)this ) ;
  Logo->setGeometry ( 10, 330, 72, 50 ) ;
  Logo->setBackgroundPixmap ( logopix ) ;
  Logo->show ( ) ;
#else /* FGLRX_OGL_INFO */
 if( m_IsFireGL )
 {
  // ========
  DInfo = new QLabel ( tr("Display Driver"), (QWidget *)this ) ;
//  DInfo->setFont (QFont( "Helvetica", 18 ) ) ;
  DInfo->setGeometry ( 10, 230, 300, 20 ) ;
  DInfo->setAutoResize ( TRUE ) ;
  DInfo->setBackgroundPixmap ( pixmap ) ;
  DInfo->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  DInfo->show ( ) ;

  DriverVersion = new QLabel ( tr("Driver Version :"), (QWidget *)this ) ;
  DriverVersion->setGeometry ( 20, 260, 300, 20 ) ;
  DriverVersion->setAutoResize ( TRUE ) ;
  DriverVersion->setBackgroundPixmap ( pixmap ) ;
  DriverVersion->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  DriverVersion->show ( ) ;

  DriverVersion1 = new QLabel ( BoardInfo.DriverVersion ( ), (QWidget *)this ) ;
  DriverVersion1->setGeometry ( 180, 260, 300, 20 ) ;
  DriverVersion1->setAutoResize ( TRUE ) ;
  DriverVersion1->setBackgroundPixmap ( pixmap ) ;
  DriverVersion1->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  DriverVersion1->show ( ) ;
 }

  Logo = new QLabel ( "", (QWidget *)this ) ;
  Logo->setGeometry ( 10, 295, 72, 50 ) ;
  Logo->setBackgroundPixmap ( logopix ) ;
  Logo->show ( ) ;
#endif /* FGLRX_OGL_INFO */
}

void InfoPage::OnActivate ( int nPage )
{
  if ( nPage != INFO_PAGE ) return ;
  if ( m_Init ) return ;
  Init ( ) ;
  m_Init = TRUE ;
}

// ### EOF ###
