static char cpuusage_c_rcsid[]="cpuusage.c,v 1.2 1994/12/01 14:45:57 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * cpuusage.c,v
 * Revision 1.2  1994/12/01  14:45:57  kerce
 * Solaris 2.x mods
 *
 * Revision 1.1.1.1  1994/06/18  19:43:29  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#if defined(SYSV) || defined(SVR4)
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/At/Plotter.h>
#include <X11/At/XYAxis.h>
#include <X11/At/XYLinePlot.h>
#include <X11/At/BarPlot.h>
#include "stdstuff.h"
#include "error.h"
#include "strdup.h"
#include "stack.h"
#include "help.h"
#include "acctfile.h"
#include "working.h"
#include "print.h"
#include "util.h"
#include "request.h"
#include "cpuusage.h"

#define	MAXZOOMS	3

extern XtAppContext XAppContext;
extern Widget TopLevelW;
extern unsigned long int StartupTimeOfDayInSecs;

typedef struct
{
  double XMin, XMax, YMin, YMax;
}
ZoomStackItemt;

typedef struct
{
  int Time;
  double User, Sys, UserAndSys;
}
CPUPoint;

typedef struct
{
  int Time;
  double Wallclock;
}
WallclockPoint;

typedef struct
{
  unsigned int Days;
  unsigned int Start;
  char *QName;
  char *HostName;
  char *QComplexStr;
  char *Group;
  char *Owner;
  char *JobName;

  ACCTFILE *AcctFile;

  CPUPoint *CPUUsagePoints;
  WallclockPoint *WallclockUsagePoints;
  char **TimeAxisLabels;

  Widget CPUUsageParentParentW;

  Widget CPUUsageParentW;
  Widget CPUUsageFormW;
  Widget CPUUsageTitleLabelW;
  Widget CPUUsageCPUButtonW;
  Widget CPUUsageLineButtonW;
  Widget CPUUsageGridButtonW;
  Widget CPUUsageLegendButtonW;
  Widget CPUUsagePrintButtonW;
  Widget CPUUsageHelpButtonW;
  Widget CPUUsageDoneButtonW;
  Widget CPUUsageUnzoomButtonW;

  Widget WallclockUsageBarPlotterW;
  Widget WallclockUsageBarPlotterXAxisW;
  Widget WallclockUsageBarPlotterYAxisW;
  Widget WallclockUsageBarPlotterWallclockW;

  Widget WallclockUsageLinePlotterW;
  Widget WallclockUsageLinePlotterXAxisW;
  Widget WallclockUsageLinePlotterYAxisW;
  Widget WallclockUsageLinePlotterWallclockW;

  Widget CPUUsageBarPlotterW;
  Widget CPUUsageBarPlotterXAxisW;
  Widget CPUUsageBarPlotterYAxisW;
  Widget CPUUsageBarPlotterUserW;
  Widget CPUUsageBarPlotterSysW;
  Widget CPUUsageBarPlotterUserAndSysW;

  Widget CPUUsageLinePlotterW;
  Widget CPUUsageLinePlotterXAxisW;
  Widget CPUUsageLinePlotterYAxisW;
  Widget CPUUsageLinePlotterUserW;
  Widget CPUUsageLinePlotterSysW;
  Widget CPUUsageLinePlotterUserAndSysW;

  Widget CPUUsageIntervalBeginEndLabelW;
  char CPUUsageIntervalBeginEndLabel[MAX_STRING_SIZE];

  Boolean CPU;
  Boolean LinePlot;
  Boolean Legend;
  STACK *ZoomStack;
}
CPUUsagePlotWt;

static XtWorkProcId WorkProcId = 0;
static CPUUsagePlotWt *CPUUsagePlotW = NULL;

static void
CPUUsageHelp (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "CPUUsageHelp"));

  Help ("Usage");

  DEXIT;
}

static void
CPUUsageDone (W, CPUUsagePlotW, CallData)
     Widget W;
     CPUUsagePlotWt *CPUUsagePlotW;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "CPUUsageDone"));

  XtPopdown (CPUUsagePlotW->CPUUsageParentW);

  stack_free (CPUUsagePlotW->ZoomStack, STACK_NODEALLOC);
  XtDestroyWidget (CPUUsagePlotW->WallclockUsageBarPlotterW);
  XtDestroyWidget (CPUUsagePlotW->WallclockUsageBarPlotterXAxisW);
  XtDestroyWidget (CPUUsagePlotW->WallclockUsageBarPlotterYAxisW);
  XtDestroyWidget (CPUUsagePlotW->WallclockUsageBarPlotterWallclockW);
  XtDestroyWidget (CPUUsagePlotW->WallclockUsageLinePlotterW);
  XtDestroyWidget (CPUUsagePlotW->WallclockUsageLinePlotterXAxisW);
  XtDestroyWidget (CPUUsagePlotW->WallclockUsageLinePlotterYAxisW);
  XtDestroyWidget (CPUUsagePlotW->WallclockUsageLinePlotterWallclockW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageBarPlotterXAxisW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageBarPlotterYAxisW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageBarPlotterUserAndSysW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageBarPlotterUserW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageBarPlotterSysW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageLinePlotterXAxisW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageLinePlotterYAxisW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageLinePlotterUserAndSysW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageLinePlotterUserW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageLinePlotterSysW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageParentW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageFormW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageTitleLabelW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageBarPlotterW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageLinePlotterW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageLineButtonW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageGridButtonW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsagePrintButtonW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageHelpButtonW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageDoneButtonW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageUnzoomButtonW);
  XtDestroyWidget (CPUUsagePlotW->CPUUsageIntervalBeginEndLabelW);

  free (CPUUsagePlotW->CPUUsagePoints);
  free (CPUUsagePlotW->QName);
  free (CPUUsagePlotW->HostName);
  free (CPUUsagePlotW->QComplexStr);
  free (CPUUsagePlotW->Group);
  free (CPUUsagePlotW->Owner);
  free (CPUUsagePlotW->JobName);
  free (CPUUsagePlotW);
  CPUUsagePlotW = NULL;

  DEXIT;
}

static void
CPUUsageZoom (W, CPUUsagePlotW, CallData)
     Widget W;
     CPUUsagePlotWt *CPUUsagePlotW;
     AtRectangleCallbackData *CallData;
{
  Arg args[4];
  double x1, y1, x2, y2;
  double xl, yl;
  double minxlen, minylen;
  ZoomStackItemt ZSItem;
  char ErrMsg[MAX_STRING_SIZE];
  Widget *XAxis, *YAxis;

  DENTER ((DQS_EVENT, "CPUUsageZoom"));

  if (CPUUsagePlotW->LinePlot == False)
    {
      sprintf (ErrMsg, "Cannot zoom on bar plot.\n");
      strcat (ErrMsg, "Select line plot, then try zooming.");
      ErrorPopup (W, ErrMsg);
      
      DEXIT;
      return;
    }

  if (CPUUsagePlotW->CPU == True)
    {
      XAxis = &CPUUsagePlotW->CPUUsageLinePlotterXAxisW;
      YAxis = &CPUUsagePlotW->CPUUsageLinePlotterYAxisW;
    }
  else
    {
      XAxis = &CPUUsagePlotW->WallclockUsageLinePlotterXAxisW;
      YAxis = &CPUUsagePlotW->WallclockUsageLinePlotterYAxisW;
    }

  if (stack_size (CPUUsagePlotW->ZoomStack) == 0)
    XtUnmapWidget (CPUUsagePlotW->CPUUsageLineButtonW);

  XtVaGetValues (*XAxis,
		 XtNmin, &ZSItem.XMin,
		 XtNmax, &ZSItem.XMax, NULL);
  XtVaGetValues (*YAxis,
		 XtNmin, &ZSItem.YMin,
		 XtNmax, &ZSItem.YMax, NULL);

  minxlen = (ZSItem.XMax - ZSItem.XMin) / 10.0;
  minylen = (ZSItem.YMax - ZSItem.YMin) / 10.0;

  if (stack_size (CPUUsagePlotW->ZoomStack) < MAXZOOMS)
    {
      char *stack_pushResult;

      stack_pushResult =
	stack_push (CPUUsagePlotW->ZoomStack, &ZSItem, sizeof (ZSItem));
      if (stack_pushResult == NULL)
	{
	  Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
	  DEXIT;
	  exit (EXIT_FAILURE);
	}
    }
  else
    {
      sprintf (ErrMsg, "Cannot zoom more than %u times.", MAXZOOMS);
      ErrorPopup (W, ErrMsg);
      
      DEXIT;
      return;
    }

  x1 = CallData->x11;
  x2 = CallData->x12;
  y1 = CallData->y11;
  y2 = CallData->y12;
  xl = fabs (x2 - x1);
  yl = fabs (y2 - y1);

  if ((xl < minxlen) || (yl < minylen))
    {
      ZoomStackItemt *ZSItem;

      sprintf (ErrMsg, "Cannot zoom that much.");
      ErrorPopup (W, ErrMsg);
  
      ZSItem = (ZoomStackItemt *) stack_pop (CPUUsagePlotW->ZoomStack);
      if (ZSItem  == NULL)
	{
	  Error (NULL, 0, 0, "INTERNAL ERROR: zoom stack empty");
	  DEXIT;
	  exit (EXIT_FAILURE);
	}

      DEXIT;
      return;
    }

  XtSetArg (args[0], XtNmin, &x1);
  XtSetArg (args[1], XtNmax, &x2);
  XtSetArg (args[2], XtNautoScale, False);
  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterXAxisW, args, 3);
  XtSetValues (CPUUsagePlotW->WallclockUsageLinePlotterXAxisW, args, 3);

  XtSetArg (args[0], XtNmin, &y1);
  XtSetArg (args[1], XtNmax, &y2);
  XtSetArg (args[2], XtNautoScale, False);
  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterYAxisW, args, 3);
  XtSetValues (CPUUsagePlotW->WallclockUsageLinePlotterYAxisW, args, 3);

  XtMapWidget (CPUUsagePlotW->CPUUsageUnzoomButtonW);

  DEXIT;
}

static void
CPUUsageUnzoom (W, CPUUsagePlotW, CallData)
     Widget W;
     CPUUsagePlotWt *CPUUsagePlotW;
     AtRectangleCallbackData *CallData;
{
  Arg args[4];
  double x1, y1, x2, y2;
  ZoomStackItemt *ZSItem;
  Widget *XAxis, *YAxis;

  DENTER ((DQS_EVENT, "CPUUsageUnzoom"));
  
  ZSItem = (ZoomStackItemt *) stack_pop (CPUUsagePlotW->ZoomStack);
  if (ZSItem  == NULL)
    {
      Error (NULL, 0, 0, "INTERNAL ERROR: zoom stack empty");
      DEXIT;
      exit (EXIT_FAILURE);
    }

/*
  if (CPUUsagePlotW->CPU == True)
    {
      XAxis = &CPUUsagePlotW->CPUUsageLinePlotterXAxisW;
      YAxis = &CPUUsagePlotW->CPUUsageLinePlotterYAxisW;
    }
  else
    {
      XAxis = &CPUUsagePlotW->WallclockUsageLinePlotterXAxisW;
      YAxis = &CPUUsagePlotW->WallclockUsageLinePlotterYAxisW;
    }
*/

  XtSetArg (args[0], XtNmin, &ZSItem->XMin);
  XtSetArg (args[1], XtNmax, &ZSItem->XMax);
  XtSetArg (args[2], XtNautoScale, False);
  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterXAxisW, args, 3);
  XtSetValues (CPUUsagePlotW->WallclockUsageLinePlotterXAxisW, args, 3);

  XtSetArg (args[0], XtNmin, &ZSItem->YMin);
  XtSetArg (args[1], XtNmax, &ZSItem->YMax);
  XtSetArg (args[2], XtNautoScale, False);
  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterYAxisW, args, 3);
  XtSetValues (CPUUsagePlotW->WallclockUsageLinePlotterYAxisW, args, 3);

  if (stack_size (CPUUsagePlotW->ZoomStack) == 0)
    {
      XtUnmapWidget (CPUUsagePlotW->CPUUsageUnzoomButtonW);
      XtMapWidget (CPUUsagePlotW->CPUUsageLineButtonW);
    }

  DEXIT;
}

static void
CPUUsageCPUCallback (W, CPUUsagePlotW)
     Widget W;
     CPUUsagePlotWt *CPUUsagePlotW;
{
  Arg args[2];

  DENTER ((DQS_EVENT, "CPUUsageCPUCallback"));

  CPUUsagePlotW->CPU = (CPUUsagePlotW->CPU == True) ? False : True;
  
  if (CPUUsagePlotW->CPU == True)
    {
      XtSetArg (args[0], XtNlabel, "Queue");

      if (CPUUsagePlotW->LinePlot == True)
	{
	  XtUnmapWidget (CPUUsagePlotW->WallclockUsageLinePlotterW);
	  XtMapWidget (CPUUsagePlotW->CPUUsageLinePlotterW);
	}
      else
	{
	  XtUnmapWidget (CPUUsagePlotW->WallclockUsageBarPlotterW);
	  XtMapWidget (CPUUsagePlotW->CPUUsageBarPlotterW);
	}
    }
  else
    {
      XtSetArg (args[0], XtNlabel, "CPU");

      if (CPUUsagePlotW->LinePlot == True)
	{
	  XtUnmapWidget (CPUUsagePlotW->CPUUsageLinePlotterW);
	  XtMapWidget (CPUUsagePlotW->WallclockUsageLinePlotterW);
	}
      else
	{
	  XtUnmapWidget (CPUUsagePlotW->CPUUsageBarPlotterW);
	  XtMapWidget (CPUUsagePlotW->WallclockUsageBarPlotterW);
	}
    }

  XtSetValues (CPUUsagePlotW->CPUUsageCPUButtonW, args, 1);

  DEXIT;
}

static void
CPUUsageLineCallback (W, CPUUsagePlotW)
     Widget W;
     CPUUsagePlotWt *CPUUsagePlotW;
{
  Arg args[2];

  DENTER ((DQS_EVENT, "CPUUsageLineCallback"));

  CPUUsagePlotW->LinePlot = (CPUUsagePlotW->LinePlot == True) ? False : True;
  
  if (CPUUsagePlotW->LinePlot == True)
    {
      XtSetArg (args[0], XtNlabel, "Bar");

      XtUnmapWidget (CPUUsagePlotW->WallclockUsageBarPlotterW);
      XtUnmapWidget (CPUUsagePlotW->CPUUsageBarPlotterW);

      if (CPUUsagePlotW->CPU == True)
	XtMapWidget (CPUUsagePlotW->CPUUsageLinePlotterW);
      else
	XtMapWidget (CPUUsagePlotW->WallclockUsageLinePlotterW);
    }
  else
    {
      XtSetArg (args[0], XtNlabel, "Line");

      XtUnmapWidget (CPUUsagePlotW->WallclockUsageLinePlotterW);
      XtUnmapWidget (CPUUsagePlotW->CPUUsageLinePlotterW);

      if (CPUUsagePlotW->CPU == True)
	XtMapWidget (CPUUsagePlotW->CPUUsageBarPlotterW);
      else
	XtMapWidget (CPUUsagePlotW->WallclockUsageBarPlotterW);
    }

  XtSetValues (CPUUsagePlotW->CPUUsageLineButtonW, args, 1);

  DEXIT;
}

static void
CPUUsageGridCallback (W, CPUUsagePlotW)
     Widget W;
     CPUUsagePlotWt *CPUUsagePlotW;
{
  Arg args[2];
  Boolean f;

  DENTER ((DQS_EVENT, "CPUUsageGridCallback"));

  XtVaGetValues (CPUUsagePlotW->CPUUsageLinePlotterXAxisW, XtNdrawGrid,
		 &f, NULL);
  f = (f == True) ? False : True;
  XtSetArg (args[0], XtNdrawGrid, f);

  XtSetValues (CPUUsagePlotW->WallclockUsageBarPlotterXAxisW, args, 1);
  XtSetValues (CPUUsagePlotW->WallclockUsageBarPlotterYAxisW, args, 1);
  XtSetValues (CPUUsagePlotW->WallclockUsageLinePlotterXAxisW, args, 1);
  XtSetValues (CPUUsagePlotW->WallclockUsageLinePlotterYAxisW, args, 1);
  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterXAxisW, args, 1);
  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterYAxisW, args, 1);
  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterXAxisW, args, 1);
  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterYAxisW, args, 1);

  if (f == False)
    XtSetArg (args[0], XtNlabel, "Grid");
  else
    XtSetArg (args[0], XtNlabel, "No Grid");

  XtSetValues (CPUUsagePlotW->CPUUsageGridButtonW, args, 1);

  DEXIT;
}

static void
CPUUsageLegendCallback (W, CPUUsagePlotW)
     Widget W;
     CPUUsagePlotWt *CPUUsagePlotW;
{
  Arg args[2];
  Boolean f;

  DENTER ((DQS_EVENT, "CPUUsageLegendCallback"));

  XtVaGetValues (CPUUsagePlotW->WallclockUsageBarPlotterW, XtNshowLegend,
		 &f, NULL);
  f = (f == True) ? False : True;
  XtSetArg (args[0], XtNshowLegend, f);


  XtSetValues (CPUUsagePlotW->WallclockUsageBarPlotterW, args, 1);
  XtSetValues (CPUUsagePlotW->WallclockUsageLinePlotterW, args, 1);
  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterW, args, 1);
  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterW, args, 1);

  if (f == False)
    XtSetArg (args[0], XtNlabel, "Legend");
  else
    XtSetArg (args[0], XtNlabel, "No Legend");

  XtSetValues (CPUUsagePlotW->CPUUsageLegendButtonW, args, 1);

  DEXIT;
}

static void
MakeWallclockBarPlotter (CPUUsagePlotW)
     CPUUsagePlotWt *CPUUsagePlotW;
{
  Arg Args[2];
  int n;

  DENTER ((DQS_EVENT, "MakeWallclockBarPlotter"));

  /* X and Y axes. */
  CPUUsagePlotW->WallclockUsageBarPlotterXAxisW =
    XtCreateWidget ("WallclockUsageBarPlotterXAxis", atXYAxisWidgetClass,
		    CPUUsagePlotW->WallclockUsageBarPlotterW, NULL, ZERO);

  CPUUsagePlotW->WallclockUsageBarPlotterYAxisW =
    XtCreateWidget ("WallclockUsageBarPlotterYAxis", atXYAxisWidgetClass,
		    CPUUsagePlotW->WallclockUsageBarPlotterW, NULL, ZERO);

  n = 0;
  XtSetArg (Args[n], XtNxAxis, CPUUsagePlotW->WallclockUsageBarPlotterXAxisW);
  n++;
  XtSetArg (Args[n], XtNyAxis, CPUUsagePlotW->WallclockUsageBarPlotterYAxisW);
  n++;
  XtSetValues (CPUUsagePlotW->WallclockUsageBarPlotterW, Args, n);

  XtAddCallback (CPUUsagePlotW->WallclockUsageBarPlotterW, XtNdragCallback,
		 (XtCallbackProc) CPUUsageZoom, CPUUsagePlotW);

  CPUUsagePlotW->WallclockUsageBarPlotterWallclockW =
    XtCreateWidget ("WallclockUsageBarPlotterWallclock", atBarPlotWidgetClass,
		    CPUUsagePlotW->WallclockUsageBarPlotterW, NULL, ZERO);

  AtBarPlotAttachData (CPUUsagePlotW->WallclockUsageBarPlotterWallclockW,
		       (XtPointer) &(CPUUsagePlotW->WallclockUsagePoints +
				     0)->Wallclock,
		       AtFloat, sizeof (WallclockPoint), 0,
		       CPUUsagePlotW->AcctFile->Wallclock.NumPoints);

  DEXIT;
}

static void
MakeWallclockLinePlotter (CPUUsagePlotW)
     CPUUsagePlotWt *CPUUsagePlotW;
{
  Arg Args[2];
  int n;

  DENTER ((DQS_EVENT, "MakeWallclockLinePlotter"));

  /* X and Y axes. */
  CPUUsagePlotW->WallclockUsageLinePlotterXAxisW =
    XtCreateWidget ("WallclockUsageLinePlotterXAxis", atXYAxisWidgetClass,
		    CPUUsagePlotW->WallclockUsageLinePlotterW, NULL, ZERO);

  CPUUsagePlotW->WallclockUsageLinePlotterYAxisW =
    XtCreateWidget ("WallclockUsageLinePlotterYAxis", atXYAxisWidgetClass,
		    CPUUsagePlotW->WallclockUsageLinePlotterW, NULL, ZERO);

  n = 0;
  XtSetArg (Args[n], XtNxAxis, CPUUsagePlotW->WallclockUsageLinePlotterXAxisW);
  n++;
  XtSetArg (Args[n], XtNyAxis, CPUUsagePlotW->WallclockUsageLinePlotterYAxisW);
  n++;
  XtSetValues (CPUUsagePlotW->WallclockUsageLinePlotterW, Args, n);

  XtAddCallback (CPUUsagePlotW->WallclockUsageLinePlotterW, XtNdragCallback,
		 (XtCallbackProc) CPUUsageZoom, CPUUsagePlotW);

  CPUUsagePlotW->WallclockUsageLinePlotterWallclockW =
    XtCreateWidget ("WallclockUsageLinePlotterWallclock",
		    atXYLinePlotWidgetClass,
		    CPUUsagePlotW->WallclockUsageLinePlotterW, NULL, ZERO);

  AtXYLinePlotAttachData (CPUUsagePlotW->WallclockUsageLinePlotterWallclockW,
			  (XtPointer) &(CPUUsagePlotW->WallclockUsagePoints +
					0)->Time,
			  AtInt, sizeof (WallclockPoint),
			  (XtPointer) &(CPUUsagePlotW->WallclockUsagePoints +
					0)->Wallclock,
			  AtFloat, sizeof (WallclockPoint), 0,
			  CPUUsagePlotW->AcctFile->Wallclock.NumPoints);

  DEXIT;
}

static void
MakeCPUBarPlotter (CPUUsagePlotW)
     CPUUsagePlotWt *CPUUsagePlotW;
{
  Arg Args[2];
  int n;

  DENTER ((DQS_EVENT, "MakeCPUBarPlotter"));

  /* X and Y axes. */
  CPUUsagePlotW->CPUUsageBarPlotterXAxisW =
    XtCreateWidget ("CPUUsageBarPlotterXAxis", atXYAxisWidgetClass,
		    CPUUsagePlotW->CPUUsageBarPlotterW, NULL, ZERO);

  CPUUsagePlotW->CPUUsageBarPlotterYAxisW =
    XtCreateWidget ("CPUUsageBarPlotterYAxis", atXYAxisWidgetClass,
		    CPUUsagePlotW->CPUUsageBarPlotterW, NULL, ZERO);

  n = 0;
  XtSetArg (Args[n], XtNxAxis, CPUUsagePlotW->CPUUsageBarPlotterXAxisW);
  n++;
  XtSetArg (Args[n], XtNyAxis, CPUUsagePlotW->CPUUsageBarPlotterYAxisW);
  n++;
  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterW, Args, n);

  XtAddCallback (CPUUsagePlotW->CPUUsageBarPlotterW, XtNdragCallback,
		 (XtCallbackProc) CPUUsageZoom, CPUUsagePlotW);

/*
  {
    unsigned long i;

    for (i = 0; i < CPUUsagePlotW->AcctFile->CPU.NumPoints; i++)
      printf ("%lu\t%s\n", i, CPUUsagePlotW->TimeAxisLabels[i]);
  }

  AtLabelAxisAttachData (CPUUsagePlotW->CPUUsageBarPlotterXAxisW,
			 &CPUUsagePlotW->TimeAxisLabels[0],
			 sizeof (CPUUsagePlotW->TimeAxisLabels[0]), 0,
			 CPUUsagePlotW->AcctFile->CPU.NumPoints);
*/

  CPUUsagePlotW->CPUUsageBarPlotterUserAndSysW =
    XtCreateWidget ("CPUUsageBarPlotterUserAndSys", atBarPlotWidgetClass,
		    CPUUsagePlotW->CPUUsageBarPlotterW, NULL, ZERO);

  CPUUsagePlotW->CPUUsageBarPlotterUserW =
    XtCreateWidget ("CPUUsageBarPlotterUser", atBarPlotWidgetClass,
		    CPUUsagePlotW->CPUUsageBarPlotterW, NULL, ZERO);

  CPUUsagePlotW->CPUUsageBarPlotterSysW =
    XtCreateWidget ("CPUUsageBarPlotterSys", atBarPlotWidgetClass,
		    CPUUsagePlotW->CPUUsageBarPlotterW, NULL, ZERO);

  AtBarPlotAttachData (CPUUsagePlotW->CPUUsageBarPlotterUserAndSysW,
		       (XtPointer) &(CPUUsagePlotW->CPUUsagePoints +
				     0)->UserAndSys,
		       AtFloat, sizeof (CPUPoint), 0,
		       CPUUsagePlotW->AcctFile->CPU.NumPoints);

  AtBarPlotAttachData (CPUUsagePlotW->CPUUsageBarPlotterUserW,
		       (XtPointer) &(CPUUsagePlotW->CPUUsagePoints +
				     0)->User,
		       AtFloat, sizeof (CPUPoint), 0,
		       CPUUsagePlotW->AcctFile->CPU.NumPoints);

  AtBarPlotAttachData (CPUUsagePlotW->CPUUsageBarPlotterSysW,
		       (XtPointer) &(CPUUsagePlotW->CPUUsagePoints +
				     0)->Sys,
		       AtFloat, sizeof (CPUPoint), 0,
		       CPUUsagePlotW->AcctFile->CPU.NumPoints);

  DEXIT;
}

static void
MakeCPULinePlotter (CPUUsagePlotW)
     CPUUsagePlotWt *CPUUsagePlotW;
{
  Arg Args[2];
  int n;

  DENTER ((DQS_EVENT, "MakeCPULinePlotter"));

  /* X and Y axes. */
  CPUUsagePlotW->CPUUsageLinePlotterXAxisW =
    XtCreateWidget ("CPUUsageLinePlotterXAxis", atXYAxisWidgetClass,
		    CPUUsagePlotW->CPUUsageLinePlotterW, NULL, ZERO);

  CPUUsagePlotW->CPUUsageLinePlotterYAxisW =
    XtCreateWidget ("CPUUsageLinePlotterYAxis", atXYAxisWidgetClass,
		    CPUUsagePlotW->CPUUsageLinePlotterW, NULL, ZERO);

  n = 0;
  XtSetArg (Args[n], XtNxAxis, CPUUsagePlotW->CPUUsageLinePlotterXAxisW);
  n++;
  XtSetArg (Args[n], XtNyAxis, CPUUsagePlotW->CPUUsageLinePlotterYAxisW);
  n++;
  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterW, Args, n);

  XtAddCallback (CPUUsagePlotW->CPUUsageLinePlotterW, XtNdragCallback,
		 (XtCallbackProc) CPUUsageZoom, CPUUsagePlotW);

  CPUUsagePlotW->CPUUsageLinePlotterUserAndSysW =
    XtCreateWidget ("CPUUsageLinePlotterUserAndSys",
		    atXYLinePlotWidgetClass,
		    CPUUsagePlotW->CPUUsageLinePlotterW, NULL, ZERO);

  CPUUsagePlotW->CPUUsageLinePlotterUserW =
    XtCreateWidget ("CPUUsageLinePlotterUser", atXYLinePlotWidgetClass,
		    CPUUsagePlotW->CPUUsageLinePlotterW, NULL, ZERO);

  CPUUsagePlotW->CPUUsageLinePlotterSysW =
    XtCreateWidget ("CPUUsageLinePlotterSys", atXYLinePlotWidgetClass,
		    CPUUsagePlotW->CPUUsageLinePlotterW, NULL, ZERO);

  AtXYLinePlotAttachData (CPUUsagePlotW->CPUUsageLinePlotterUserW,
			  (XtPointer) &(CPUUsagePlotW->CPUUsagePoints +
					0)->Time,
			  AtInt, sizeof (CPUPoint),
			  (XtPointer) &(CPUUsagePlotW->CPUUsagePoints +
					0)->User,
			  AtFloat, sizeof (CPUPoint), 0,
			  CPUUsagePlotW->AcctFile->CPU.NumPoints);

  AtXYLinePlotAttachData (CPUUsagePlotW->CPUUsageLinePlotterSysW,
			  (XtPointer) &(CPUUsagePlotW->CPUUsagePoints +
					0)->Time,
			  AtInt, sizeof (CPUPoint),
			  (XtPointer) &(CPUUsagePlotW->CPUUsagePoints +
					0)->Sys,
			  AtFloat, sizeof (CPUPoint), 0,
			  CPUUsagePlotW->AcctFile->CPU.NumPoints);

  AtXYLinePlotAttachData (CPUUsagePlotW->CPUUsageLinePlotterUserAndSysW,
			  (XtPointer) &(CPUUsagePlotW->CPUUsagePoints +
					0)->Time,
			  AtInt, sizeof (CPUPoint),
			  (XtPointer) &(CPUUsagePlotW->CPUUsagePoints +
					0)->UserAndSys,
			  AtFloat, sizeof (CPUPoint), 0,
			  CPUUsagePlotW->AcctFile->CPU.NumPoints);

  DEXIT;
}

static void
CPUUsage (CPUUsagePlotW)
     CPUUsagePlotWt *CPUUsagePlotW;
{
  Arg wargs[10];

  DENTER ((DQS_EVENT, "CPUUsage"));

  CPUUsagePlotW->CPUUsageParentW =
    XtCreatePopupShell ("CPUUsageParent", transientShellWidgetClass,
			CPUUsagePlotW->CPUUsageParentParentW, NULL, ZERO);
  
  CPUUsagePlotW->CPUUsageFormW =
    XtCreateManagedWidget ("CPUUsageForm", formWidgetClass,
			   CPUUsagePlotW->CPUUsageParentW, NULL, ZERO);
  
  CPUUsagePlotW->CPUUsageTitleLabelW =
    XtCreateManagedWidget ("CPUUsageTitle", labelWidgetClass,
			  CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  
  CPUUsagePlotW->WallclockUsageBarPlotterW =
    XtCreateManagedWidget ("WallclockUsageBarPlotter", atPlotterWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtSetMappedWhenManaged (CPUUsagePlotW->WallclockUsageBarPlotterW, False);
  
  CPUUsagePlotW->WallclockUsageLinePlotterW =
    XtCreateManagedWidget ("WallclockUsageLinePlotter", atPlotterWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtSetMappedWhenManaged (CPUUsagePlotW->WallclockUsageLinePlotterW, False);
  
  CPUUsagePlotW->CPUUsageBarPlotterW =
    XtCreateManagedWidget ("CPUUsageBarPlotter", atPlotterWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtSetMappedWhenManaged (CPUUsagePlotW->CPUUsageBarPlotterW, False);
  
  CPUUsagePlotW->CPUUsageLinePlotterW =
    XtCreateManagedWidget ("CPUUsageLinePlotter", atPlotterWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtSetMappedWhenManaged (CPUUsagePlotW->CPUUsageLinePlotterW, False);
  
  MakeWallclockBarPlotter (CPUUsagePlotW);
  MakeWallclockLinePlotter (CPUUsagePlotW);
  MakeCPUBarPlotter (CPUUsagePlotW);
  MakeCPULinePlotter (CPUUsagePlotW);
  
  {
    char *IStartAscTime, *IStopAscTime;
    struct timeval TheTime;

    TheTime.tv_sec = CPUUsagePlotW->AcctFile->IStart;
    IStartAscTime = strdup (asctime (localtime (&TheTime)));
    if (IStartAscTime == (char *) NULL)
      {
	Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
	DEXIT;
	exit (EXIT_FAILURE);
      }
    IStartAscTime[strlen (IStartAscTime) - 1] = '\0';

    TheTime.tv_sec = CPUUsagePlotW->AcctFile->IStop;
    IStopAscTime = strdup (asctime (localtime (&TheTime)));
    if (IStopAscTime == (char *) NULL)
      {
	Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
	DEXIT;
	exit (EXIT_FAILURE);
      }
    IStopAscTime[strlen (IStopAscTime) - 1] = '\0';

    sprintf (CPUUsagePlotW->CPUUsageIntervalBeginEndLabel,
	     "Interval begin: %s\n  Interval end: %s",
	     IStartAscTime, IStopAscTime);

    free (IStartAscTime);
    free (IStopAscTime);
  }

  CPUUsagePlotW->CPUUsageIntervalBeginEndLabelW =
    XtCreateManagedWidget ("CPUUsageIntervalBeginEndL", labelWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);

  XtSetArg (wargs[0], XtNlabel, CPUUsagePlotW->CPUUsageIntervalBeginEndLabel);
  XtSetValues (CPUUsagePlotW->CPUUsageIntervalBeginEndLabelW, wargs, 1);
  

  CPUUsagePlotW->CPUUsageCPUButtonW =
    XtCreateManagedWidget ("CPUUsageCPU", commandWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtAddCallback (CPUUsagePlotW->CPUUsageCPUButtonW, XtNcallback,
		 (XtCallbackProc) CPUUsageCPUCallback,
		 CPUUsagePlotW);
  
  CPUUsagePlotW->CPUUsageLineButtonW =
    XtCreateManagedWidget ("CPUUsageLine", commandWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtAddCallback (CPUUsagePlotW->CPUUsageLineButtonW, XtNcallback,
		 (XtCallbackProc) CPUUsageLineCallback,
		 CPUUsagePlotW);
  
  CPUUsagePlotW->CPUUsageGridButtonW =
    XtCreateManagedWidget ("CPUUsageGrid", commandWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtAddCallback (CPUUsagePlotW->CPUUsageGridButtonW, XtNcallback,
		 (XtCallbackProc) CPUUsageGridCallback,
		 CPUUsagePlotW);
  
  CPUUsagePlotW->CPUUsageLegendButtonW =
    XtCreateManagedWidget ("CPUUsageLegend", commandWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtAddCallback (CPUUsagePlotW->CPUUsageLegendButtonW, XtNcallback,
		 (XtCallbackProc) CPUUsageLegendCallback,
		 CPUUsagePlotW);
  
  CPUUsagePlotW->CPUUsagePrintButtonW =
    XtCreateManagedWidget ("CPUUsagePrint", commandWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtAddCallback (CPUUsagePlotW->CPUUsagePrintButtonW, XtNcallback,
		 (XtCallbackProc) DQSUsagePrint,
		 CPUUsagePlotW);
  
  CPUUsagePlotW->CPUUsageHelpButtonW =
    XtCreateManagedWidget ("CPUUsageHelp", commandWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtAddCallback (CPUUsagePlotW->CPUUsageHelpButtonW, XtNcallback,
		 (XtCallbackProc) CPUUsageHelp,
		 CPUUsagePlotW);
  
  CPUUsagePlotW->CPUUsageDoneButtonW =
    XtCreateManagedWidget ("CPUUsageDone", commandWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtAddCallback (CPUUsagePlotW->CPUUsageDoneButtonW, XtNcallback,
		 (XtCallbackProc) CPUUsageDone,
		 CPUUsagePlotW);
  
  CPUUsagePlotW->CPUUsageUnzoomButtonW =
    XtCreateManagedWidget ("CPUUsageUnzoom", commandWidgetClass,
			   CPUUsagePlotW->CPUUsageFormW, NULL, ZERO);
  XtAddCallback (CPUUsagePlotW->CPUUsageUnzoomButtonW, XtNcallback,
		 (XtCallbackProc) CPUUsageUnzoom,
		 CPUUsagePlotW);
  
  XtPopup (CPUUsagePlotW->CPUUsageParentW, XtGrabNone);
  XtMapWidget (CPUUsagePlotW->WallclockUsageBarPlotterW);
  XtUnmapWidget (CPUUsagePlotW->CPUUsageUnzoomButtonW);

  DEXIT;
}

static XtWorkProc
MakeCPUData (Data)
     XtPointer Data;
{
  CPUUsagePlotWt *CPUUsagePlotW;
  ACCTFILE *AcctFile;
  static char TextString[512];
  static int LastPercentageRead = -1;
  static REQUEST *Req;
  static BOOLEAN ReqAlloced = FALSE;
  int i;
  unsigned long Bin;
  BOOLEAN CleanUp;
  char ErrMsg[MAX_STRING_SIZE];
  
  DENTER ((DQS_EVENT, "MakeCPUData"));
  
  CPUUsagePlotW = (CPUUsagePlotWt *) Data;
  AcctFile = CPUUsagePlotW->AcctFile;
  
  if (ReqAlloced == FALSE)
    {
      Req = (REQUEST *) calloc (1, sizeof (REQUEST));
      if (Req == NULL)
	{
	  Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
	  DEXIT;
	  exit (EXIT_FAILURE);
	}
      
      Req->QName = CPUUsagePlotW->QName;
      Req->HostName = CPUUsagePlotW->HostName;
      Req->QComplexStr = CPUUsagePlotW->QComplexStr;
      if (strlen (Req->QComplexStr) != 0)
	dqs_parse_resource_list (&Req->QComplex, Req->QComplexStr);
      else
	Req->QComplex = (dqs_list_type *) NULL;
      Req->Group = CPUUsagePlotW->Group;
      Req->Owner = CPUUsagePlotW->Owner;
      Req->JobName = CPUUsagePlotW->JobName;
      
      ReqAlloced = TRUE;
    }
  
  i = AcctFileRead (AcctFile, Req, 50);
  if (i == 0)
    /* We got some data... */
    {
      if (((AcctFile->PercentageRead % 5) == 0)
	  && (AcctFile->PercentageRead != LastPercentageRead))
	{
	  sprintf (TextString, "Reading accounting file... %u%%",
		   AcctFile->PercentageRead);
	  DQSUsageWorkingUpdatePercentage (TextString);
	  
	  LastPercentageRead = AcctFile->PercentageRead;
	}
    }      
  else if (i == 1)
    /*
     *  We're done reading.
     */
    {
      if (AcctFile->Matches == 0)
	{
	  DQSUsageWorkingPopdown ();
	  
	  sprintf (ErrMsg, "No matches found in accounting file named:\n%s\n",
		   AcctFile->AcctFileName);
	  ErrorPopup (TopLevelW, ErrMsg);
	  
	  CleanUp = TRUE;
	}
      else
	{
	  CPUUsagePlotW->CPUUsagePoints =
	    (CPUPoint *) calloc (1,
				 CPUUsagePlotW->AcctFile->CPU.NumPoints *
				 sizeof (CPUPoint));
	  if (CPUUsagePlotW->CPUUsagePoints == NULL)
	    {
	      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
	      DEXIT;
	      exit (EXIT_FAILURE);
	    }
	  
	  CPUUsagePlotW->WallclockUsagePoints =
	    (WallclockPoint *)
	      calloc (1, CPUUsagePlotW->AcctFile->Wallclock.NumPoints *
		      sizeof (WallclockPoint));
	  if (CPUUsagePlotW->WallclockUsagePoints == NULL)
	    {
	      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
	      DEXIT;
	      exit (EXIT_FAILURE);
	    }
	  
	  for (Bin = 0; Bin < CPUUsagePlotW->AcctFile->CPU.NumPoints; Bin++)
	    {
	      CPUUsagePlotW->WallclockUsagePoints[Bin].Time = Bin;
	      CPUUsagePlotW->CPUUsagePoints[Bin].Time = Bin;
	      CPUUsagePlotW->WallclockUsagePoints[Bin].Wallclock =
		AcctFile->Wallclock.DataPoints[Bin];
	      CPUUsagePlotW->CPUUsagePoints[Bin].User =
		AcctFile->CPU.UserDataPoints[Bin];
	      CPUUsagePlotW->CPUUsagePoints[Bin].Sys =
		AcctFile->CPU.SysDataPoints[Bin];
	      CPUUsagePlotW->CPUUsagePoints[Bin].UserAndSys =
		AcctFile->CPU.UserDataPoints[Bin]
		  + AcctFile->CPU.SysDataPoints[Bin];
	    }
	  
	  DQSUsageWorkingPopdown ();
	  CPUUsage (CPUUsagePlotW);
	}
      
      CleanUp = TRUE;
    }
  else
    {
      sprintf (ErrMsg, "Cannot parse accounting file named:\n%s\n",
	       AcctFile->AcctFileName);
      ErrorPopup (TopLevelW, ErrMsg);
      
      DQSUsageWorkingPopdown ();
      CleanUp = TRUE;
    }
  
  if (CleanUp == TRUE)
    {
      AcctFileDestroy (AcctFile);
      dqs_free_list (Req->QComplex);
      ReqAlloced = FALSE;
      
      DEXIT;
      return ((XtWorkProc) True);
    }
  
  DEXIT;
  return ((XtWorkProc) False);
}

void
CPUUsagePrint (CPUUsagePlotWid, PlotPSFileName, Landscape)
     void *CPUUsagePlotWid;
     char *PlotPSFileName;
     BOOLEAN Landscape;
{
  Arg Args[1];
  CPUUsagePlotWt *CPUUsagePlotW = CPUUsagePlotWid;

  DENTER ((DQS_EVENT, "CPUUsagePrint"));

  if (CPUUsagePlotW->CPU == True)
    {
      if (CPUUsagePlotW->LinePlot == TRUE)
	{
	  XtSetArg (Args[0], XtNplotLineStyle, AtLineSOLID);
	  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterUserAndSysW, Args, 1);
	  
	  XtSetArg (Args[0], XtNplotLineStyle, AtLineDASHED);
	  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterUserW, Args, 1);
	  
	  XtSetArg (Args[0], XtNplotLineStyle, AtLineDOTTED5);
	  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterSysW, Args, 1);
	  
	  AtPlotterGeneratePostscript (PlotPSFileName,
				       (AtPlotterWidget)
				       CPUUsagePlotW->CPUUsageLinePlotterW,
				       PlotPSFileName, 50, 50, 520, 400,
				       Landscape);
	  
	  XtSetArg (Args[0], XtNplotLineStyle, AtLineSOLID);
	  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterUserAndSysW, Args, 1);
	  
	  XtSetArg (Args[0], XtNplotLineStyle, AtLineSOLID);
	  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterUserW, Args, 1);
	  
	  XtSetArg (Args[0], XtNplotLineStyle, AtLineSOLID);
	  XtSetValues (CPUUsagePlotW->CPUUsageLinePlotterSysW, Args, 1);
	}
      else
	/* It's a CPU Bar plot. */
	{
	  XtSetArg (Args[0], XtNshading, AtGRAY5);
	  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterUserAndSysW, Args, 1);
	  
	  XtSetArg (Args[0], XtNshading, AtGRAY3);
	  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterUserW, Args, 1);
	  
	  XtSetArg (Args[0], XtNshading, AtGRAY1);
	  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterSysW, Args, 1);
	  
	  AtPlotterGeneratePostscript (PlotPSFileName,
				       (AtPlotterWidget)
				       CPUUsagePlotW->CPUUsageBarPlotterW,
				       PlotPSFileName, 50, 50, 520, 400,
				       Landscape);
	  
	  XtSetArg (Args[0], XtNshading, AtGRAY0);
	  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterUserAndSysW, Args, 1);
	  
	  XtSetArg (Args[0], XtNshading, AtGRAY0);
	  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterUserW, Args, 1);
	  
	  XtSetArg (Args[0], XtNshading, AtGRAY0);
	  XtSetValues (CPUUsagePlotW->CPUUsageBarPlotterSysW, Args, 1);
	}
    }
  else
    /* It's a Wallclock usage plot */
    {
      if (CPUUsagePlotW->LinePlot == TRUE)
	{
	  AtPlotterGeneratePostscript (PlotPSFileName,
				       (AtPlotterWidget)
				       CPUUsagePlotW->WallclockUsageLinePlotterW,
				       PlotPSFileName, 50, 50, 520, 400,
				       Landscape);
	}
      else
	/* It's a Wallclock Bar plot. */
	{
	  XtSetArg (Args[0], XtNshading, AtGRAY5);
	  XtSetValues (CPUUsagePlotW->WallclockUsageBarPlotterWallclockW,
		       Args, 1);
	  
	  AtPlotterGeneratePostscript (PlotPSFileName,
				       (AtPlotterWidget)
				       CPUUsagePlotW->WallclockUsageBarPlotterW,
				       PlotPSFileName, 50, 50, 520, 400,
				       Landscape);
	  
	  XtSetArg (Args[0], XtNshading, AtGRAY0);
	  XtSetValues (CPUUsagePlotW->WallclockUsageBarPlotterWallclockW,
		       Args, 1);
	}
    }

  DEXIT;
}

long
CPUUsageBegin (W, Start, Days, BinSize, AcctFileName, QName, HostName,
	       QComplexStr, Group, Owner, JobName)
     Widget W;
     unsigned int Start;
     unsigned int Days;
     unsigned int BinSize;
     char *AcctFileName;
     char *QName;
     char *HostName;
     char *QComplexStr;
     char *Group;
     char *Owner;
     char *JobName;
{
  unsigned long int IStart, IStop, i;
  char *AcctFileNameCopy;
  char ErrMsg[MAX_STRING_SIZE];

  DENTER ((DQS_EVENT, "CPUUsageBegin"));

  CPUUsagePlotW = (CPUUsagePlotWt *) calloc (1, sizeof (CPUUsagePlotWt));
  if (CPUUsagePlotW == (CPUUsagePlotWt *) NULL)
    {
      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
      DEXIT;
      exit (EXIT_FAILURE);
    }

  CPUUsagePlotW->Start = Start;
  CPUUsagePlotW->Days = Days;

  IStartStopCalc (Start, Days, &IStart, &IStop, StartupTimeOfDayInSecs);

  {
    int AcctFileCreateResult;

    AcctFileNameCopy = strdup (AcctFileName);
    if (AcctFileNameCopy == (char *) NULL)
      {
	Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
	DEXIT;
	exit (EXIT_FAILURE);
      }

    CPUUsagePlotW->AcctFile =
      AcctFileCreate (AcctFileNameCopy, IStart, IStop, BinSize,
		      &AcctFileCreateResult);
    if (AcctFileCreateResult != ACCTFILE_SUCCESS)
      {
	DQSUsageWorkingPopdown ();
	free (CPUUsagePlotW);
	  
	switch (AcctFileCreateResult)
	  {
	  case ACCTFILE_OUTOFMEM:
	    sprintf (ErrMsg, "Out of memory!\nThis is probably due to an unreasonable combination\nof the values of Start, Days, and Bin Size\n");
	    break;
	  case ACCTFILE_NOFOPEN:
	    sprintf (ErrMsg, "cannot read file named `%s'\n", AcctFileName);
	    break;
	  case ACCTFILE_NOSTAT:
	    sprintf (ErrMsg, "cannot access file named `%s'\n", AcctFileName);
	    break;
	  case ACCTFILE_SMALLBINSIZE:
	    sprintf (ErrMsg, "BinSize must be > 0");
	    break;
	  case ACCTFILE_LARGEBINSIZE:
	    sprintf (ErrMsg, "BinSize must be < (EndTime - BeginTime)");
	    break;
	  case ACCTFILE_SMALLISTOP:
	    sprintf (ErrMsg, "EndTime must be >= BeginTime");
	    break;
	  case ACCTFILE_SMALLISTART:
	    sprintf (ErrMsg, "BeginTime must be >= 0");
	    break;
	  default:
	    sprintf (ErrMsg, "INTERNAL ERROR");
	    break;
	  }

	ErrorPopup (TopLevelW, ErrMsg);
	DEXIT;
	return ((long) -1);
      }

    if (CPUUsagePlotW->AcctFile->FileStat.st_size <= 0)
      {
	DQSUsageWorkingPopdown ();
	free (CPUUsagePlotW);
	  
	sprintf (ErrMsg, "accounting file named:\n%s\nis empty (zero bytes).",
		 CPUUsagePlotW->AcctFile->AcctFileName);
	ErrorPopup (TopLevelW, ErrMsg);

	DEXIT;
	return ((long) 0);
      }
  }

  CPUUsagePlotW->QName = strdup (QName);
  if (CPUUsagePlotW->QName == (char *) NULL)
    {
      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
      DEXIT;
      exit (EXIT_FAILURE);
    }

  CPUUsagePlotW->HostName = strdup (HostName);
  if (CPUUsagePlotW->HostName == (char *) NULL)
    {
      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
      DEXIT;
      exit (EXIT_FAILURE);
    }

  CPUUsagePlotW->QComplexStr = strdup (QComplexStr);
  if (CPUUsagePlotW->QComplexStr == (char *) NULL)
    {
      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
      DEXIT;
      exit (EXIT_FAILURE);
    }

  CPUUsagePlotW->Group = strdup (Group);
  if (CPUUsagePlotW->Group == (char *) NULL)
    {
      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
      DEXIT;
      exit (EXIT_FAILURE);
    }

  CPUUsagePlotW->Owner = strdup (Owner);
  if (CPUUsagePlotW->Owner == (char *) NULL)
    {
      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
      DEXIT;
      exit (EXIT_FAILURE);
    }

  CPUUsagePlotW->JobName = strdup (JobName);
  if (CPUUsagePlotW->JobName == (char *) NULL)
    {
      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
      DEXIT;
      exit (EXIT_FAILURE);
    }

/*
  CPUUsagePlotW->TimeAxisLabels =
    (char **) calloc (1, CPUUsagePlotW->AcctFile->CPU.NumPoints *
		      sizeof (char *));

  for (i = 0; i < CPUUsagePlotW->AcctFile->CPU.NumPoints; i++)
    {
      if ((i % 25) == 0)
	CPUUsagePlotW->TimeAxisLabels[i] = "foo";
      else
	CPUUsagePlotW->TimeAxisLabels[i] = NULL;
    }
*/
  
  CPUUsagePlotW->CPUUsageParentParentW = W;
  CPUUsagePlotW->CPU = False;
  CPUUsagePlotW->LinePlot = False;
  CPUUsagePlotW->ZoomStack = stack_init ();
  if (CPUUsagePlotW->ZoomStack == NULL)
    {
      Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
      DEXIT;
      exit (EXIT_FAILURE);
    }

  DEXIT;
  return ((long) CPUUsagePlotW->AcctFile->FileStat.st_size);
}

void
CPUUsageAddWorkProc ()
{
  DENTER ((DQS_EVENT, "CPUUsageAddWorkProc"));

  WorkProcId = XtAppAddWorkProc (XAppContext, (XtWorkProc) MakeCPUData,
				 (XtPointer) CPUUsagePlotW);

  DEXIT;
}

void
CPUUsageRemoveWorkProc ()
{
  DENTER ((DQS_EVENT, "CPUUsageRemoveWorkProc"));

  if (WorkProcId != 0)
    {
      XtRemoveWorkProc (WorkProcId);
      WorkProcId = 0;
    }

  DEXIT;
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
