/****************************************************************************
**
** Copyright (C) 2004-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "Release.h"

#include <qapplication.h>
#include <assert.h>

#include "globals.h"

Release * Release::release(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, RELEASE);
}

Release * Release::releaseAndRemove(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, RELEASEANDREMOVE);
}

Release * Release::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, int mode) {

   DirBase * dir = workBench->selectedItem();
   if (!dir) return NULL;

   if (dir->getType() == DirBase::Cvs) {
      Release * p = new Release(whatsThisIconSet, parent, workBench, dir, mode);
      p->acceptCvs();
   } else {
      qDebug("Release: Method not implemented");
   }
   return NULL;
}

Release::Release(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, int mode)
   :  m_whatsThisIconSet(whatsThisIconSet),
      m_parent(parent),
      m_workBench(workBench),
      m_dir(dir),
      m_dlg(NULL),
      m_mode(mode)
{
   connect(this,SIGNAL(deleteObject(QObject *)),parent,SLOT(slot_deleteObject(QObject *)));
   connect(this,SIGNAL(removeProjectSlot(DirBase *)),parent,SLOT(slot_removeProjectSlot(DirBase *)));
   connect(this,SIGNAL(rereadProject(DirBase *)),parent,SLOT(slot_rereadProject(DirBase *)));
}

Release::~Release() {
   if (m_dlg) delete m_dlg;
   m_dlg = NULL;
}

void Release::acceptCvs() {

   assert(m_dir);

   int cmd = -1;
   switch(m_mode) {
      case RELEASE: {
	 cmd = CVS_RELEASE_CMD;
	 break;
      }
      case RELEASEANDREMOVE: {
	 cmd = CVS_RELEASE_D_CMD;
	 break;
      }
      default: {
	 assert(false);
	 break;
      }
   }

   QString dir = m_dir->fullName();
   QString cvsRoot = m_dir->getRoot();
   cvsRoot = masqWs(cvsRoot);

   QString projectName = masqWs(dir.right(dir.length()-dir.findRev( "/",-2)-1));//local workdir name might be different from module name
   dir = dir.left( dir.findRev( "/",-2)); // one dir up

   QString topModule = m_dir->topControlledDir()->relativeName();
   
   callInteractive( topModule, dir, cvsRoot,
	 projectName, cmd,
	 ExtApps::g_cvsRsh.path);
}

void Release::reject() {
   emit deleteObject(this);
}

void Release::cvsCallStarted() {
   QApplication::setOverrideCursor(Qt::waitCursor);
}

void Release::cvsCallFinished() {
   QApplication::restoreOverrideCursor();
}

void Release::afterCall(int cmd,CvsBuffer*,bool failed) {
   cvsCallFinished();
   if (failed) {
      reject();
      return;
   }
   assert(m_dir);
   switch( cmd) {
      case CVS_RELEASE_CMD:
      case NOOP: {
	 break;
      }
      case CVS_RELEASE_D_CMD: {
	 if ( (DirBase *)m_dir == m_dir->topDir()) {
	    emit removeProjectSlot(m_dir);
	 } else {
	    DirBase * dir = m_dir->parent();
	    if (dir) {
	       emit rereadProject(dir);
	    }
	 }
	 break;
      }
      default: {
	 qDebug("Release::afterCall: Unknown cmd");
      }
   }
   reject();
}

