CONFIG += qt release
#CONFIG += qt debug console

TEMPLATE = app
TARGET   = zyGrib

DEPENDPATH  += . util map GUI
INCLUDEPATH += . util map GUI bzip2 zlib-1.2.3 proj-4.6.0/src

LIBS += -Lbzip2 -lbz2 -Lzlib-1.2.3 -lz -Lproj-4.6.0/src -lproj

CFLAGS += -std=c99



win32 {
	DESTDIR = release
	LIBS += -lregex
	LIBS += bgd.lib
}
else {
	DESTDIR = .
}

OBJECTS_DIR = objs
MOC_DIR = objs
UI_DIR  = GUI

QT += network xml

CODECFORTR = UTF-8
CODECFORSRC = UTF-8
TRANSLATIONS =  ../tr/zyGrib_fr.ts \
				../tr/zyGrib_cz.ts \
				../tr/zyGrib_de.ts \
				../tr/zyGrib_it.ts \
				../tr/zyGrib_nl.ts \
				../tr/zyGrib_ru.ts \
				../tr/zyGrib_es.ts

!win32 {
	# conditional, because uic dont work in my cross compilator environment.
	# ui_*.h files are made under linux before windows compilation.
	
	FORMS += GUI/PositionEditorWidget.ui \
		 	 GUI/PoiEditorDialog.ui \
			 GUI/ColorEditorWidget.ui \
			 GUI/LineEditorWidget.ui \
			 GUI/TextStyleEditorWidget.ui \
			 GUI/GraphicsParamsDialog.ui \
			 GUI/MeteotableOptionsDialog.ui \
		 	 GUI/AngleConverterWidget.ui \

}

HEADERS += \
			 GUI/PositionEditorWidget.h \
			 GUI/ColorEditorWidget.h \
			 GUI/LineEditorWidget.h \
			 GUI/TextStyleEditorWidget.h \
		 	 GUI/AngleConverterWidget.h \
		 	 GUI/AngleConverterDialog.h \
           BoardToolBar.h \
		   DataDefines.h \
		   DataQString.h \
		   DataMeteoAbstract.h \
           DataPointInfo.h \
           DateChooser.h \
		   DialogBox.h \
		   DialogBoxColumn.h \
           DialogFonts.h \
           DialogGraphicsParams.h \
           DialogLoadGRIB.h \
           DialogLoadIAC.h \
           DialogProxy.h \
           DialogServerStatus.h \
           DialogUnits.h \
           FileLoader.h \
           FileLoaderGRIB.h \
           FileLoaderIAC.h \
           Font.h \
           GshhsRangsReader.h \
           GshhsReader.h \
           GisReader.h \
           GribAnimator.h \
           GribPlot.h \
           GribReader.h \
           GribRecord.h \
		   GriddedPlotter.h \
		   GriddedRecord.h \
		   GriddedReader.h \
           IacPlot.h \
           IacReader.h \
           ImageWriter.h \
		   IrregularGridded.h \
           IsoLine.h \
           LonLatGrid.h \
           MbluePlot.h \
           MblueReader.h \
           MblueRecord.h \
           MeteoTable.h \
           MeteoTableWidget.h \
           MeteotableOptionsDialog.h \
           MainWindow.h \
           MenuBar.h \
           Orthodromie.h \
           POI.h \
           POI_Editor.h \
           PositionEditor.h \
           Projection.h \
           sha1/sha1.h \
           MapDrawer.h \
           Settings.h \
           Terrain.h \
           Util.h \
           Version.h \
           zuFile.h

SOURCES += \
			 GUI/PositionEditorWidget.cpp \
			 GUI/ColorEditorWidget.cpp \
			 GUI/LineEditorWidget.cpp \
			 GUI/TextStyleEditorWidget.cpp \
		 	 GUI/AngleConverterWidget.cpp \
		 	 GUI/AngleConverterDialog.cpp \
           BoardToolBar.cpp \
		   DataQString.cpp \
		   DataMeteoAbstract.cpp \
           DataPointInfo.cpp \
           DateChooser.cpp \
		   DialogBoxColumn.cpp \
           DialogFonts.cpp \
           DialogGraphicsParams.cpp \
           DialogLoadGRIB.cpp \
           DialogLoadIAC.cpp \
           DialogProxy.cpp \
           DialogServerStatus.cpp \
           DialogUnits.cpp \
           FileLoaderGRIB.cpp \
           FileLoaderIAC.cpp \
           Font.cpp \
		   GriddedPlotter.cpp \
		   GriddedReader.cpp \
		   GriddedRecord.cpp \
           GshhsRangsReader.cpp \
           GshhsReader.cpp \
           GribAnimator.cpp \
           GribPlot.cpp \
           GisReader.cpp \
           GribReader.cpp \
           GribRecord.cpp \
           IacPlot.cpp \
           IacReader.cpp \
           IacReaderUtil.cpp \
           ImageWriter.cpp \
		   IrregularGridded.cpp \
           IsoLine.cpp \
           LonLatGrid.cpp \
           MbluePlot.cpp \
           MblueReader.cpp \
           MblueRecord.cpp \
           main.cpp \
           MainWindow.cpp \
           MenuBar.cpp \
           MeteoTable.cpp \
           MeteoTableWidget.cpp \
           MeteotableOptionsDialog.cpp \
           Orthodromie.cpp \
           POI.cpp \
           POI_Editor.cpp \
           PositionEditor.cpp \
           Projection.cpp \
           Projection_libproj.cpp \
           sha1/sha1.cpp \
           MapDrawer.cpp \
           Settings.cpp \
           Terrain.cpp \
           Util.cpp \
           zuFile.cpp


