from Globals import DTMLFile
from AccessControl import getSecurityManager

class ProxyManager:
    """Manage proxy role settings"""

    _proxy_roles=()

    manage_options=(
            {'label':'Proxy', 'action':'manage_proxyForm',
             'help':('OFSP','DTML-DocumentOrMethod_Proxy.stx')},
    )
                   
    __ac_permissions__=(
        ('Change proxy roles', ('manage_proxyForm', 'manage_proxy')),
    )

    manage_proxyForm=DTMLFile('documentProxy', globals())

    def manage_haveProxy(self,r): return r in self._proxy_roles

    def _validateProxy(self, request, roles=None):
        if roles is None: roles=self._proxy_roles
        if not roles: return
        user=u=getSecurityManager().getUser()
        user=user.hasRole
        for r in roles:
            if r and not user(self, (r,)):
                user=None
                break

        if user is not None: return

        raise 'Forbidden', (
            'You are not authorized to change <em>%s</em> because you '
            'do not have proxy roles.\n<!--%s, %s-->' % (self.__name__, u, roles))





    def manage_proxy(self, roles=(), REQUEST=None):
        "Change Proxy Roles"
        self._validateProxy(REQUEST, roles)
        self._validateProxy(REQUEST)
        self._proxy_roles=tuple(roles)
        if REQUEST:
            return self.manage_proxyForm(self, REQUEST,
                manage_tabs_message='Saved changes.')

