
from Testing import ZopeTestCase

ZopeTestCase.installProduct('CMFCore', quiet=1)
ZopeTestCase.installProduct('CMFDefault', quiet=1)
ZopeTestCase.installProduct('CMFCalendar', quiet=1)
ZopeTestCase.installProduct('CMFTopic', quiet=1)
ZopeTestCase.installProduct('DCWorkflow', quiet=1)
ZopeTestCase.installProduct('CMFActionIcons', quiet=1)
ZopeTestCase.installProduct('CMFQuickInstallerTool', quiet=1)
ZopeTestCase.installProduct('CMFFormController', quiet=1)
ZopeTestCase.installProduct('GroupUserFolder', quiet=1)
ZopeTestCase.installProduct('ZCTextIndex', quiet=1)
ZopeTestCase.installProduct('TextIndexNG2', quiet=1)
ZopeTestCase.installProduct('SecureMailHost', quiet=1)
ZopeTestCase.installProduct('CMFPlone', quiet=1)

ZopeTestCase.installProduct('PloneLanguageTool')
ZopeTestCase.installProduct('Archetypes')
ZopeTestCase.installProduct('PortalTransforms', quiet=1)
ZopeTestCase.installProduct('MimetypesRegistry', quiet=1)

# Make sure the dummy types are registered
from Products.LinguaPlone.tests import dummy
ZopeTestCase.installProduct('LinguaPlone')

from AccessControl.SecurityManagement import newSecurityManager
from AccessControl.SecurityManagement import noSecurityManager

from Acquisition import aq_base
import time

from Products.LinguaPlone import config
from Products.LinguaPlone.tests import utils

from Products.CMFPlone.tests import PloneTestCase

portal_owner = PloneTestCase.portal_owner
portal_name = PloneTestCase.portal_name
default_user = PloneTestCase.default_user


class LinguaPloneTestCase(PloneTestCase.PloneTestCase):

    def _setup(self):
        # Transparently extend the base setup
        PloneTestCase.PloneTestCase._setup(self)
        utils.setupDummySession(self.app.REQUEST)
        utils.setupGlobalRequest(self.app.REQUEST)

    def addLanguage(self, language):
        self.portal.portal_languages.addSupportedLanguage(language)

    def setLanguage(self, language):
        request = self.app.REQUEST
        request.cookies['I18N_CONTENT_LANGUAGE'] = language
        request.cookies['I18N_LANGUAGE'] = language
        request['set_language'] = language
        session = request.get('SESSION')
        session['pts_language'] = 'language'
        request.SESSION = session
 
    def makeContent(self, context, portal_type, id='doc', **kw):
        context.invokeFactory(portal_type, id, **kw)
        return getattr(context, id)

    def makeTranslation(self, content, language='en'):
        content.addTranslation(language)
        return content.getTranslation(language)
        

def setupLinguaPlone(app, portal_name, quiet):
    portal = app[portal_name]
    start = time.time()
    if not quiet: ZopeTestCase._print('Adding LinguaPlone ... ')
    # Login as portal owner
    user = app.acl_users.getUserById(portal_owner).__of__(app.acl_users)
    newSecurityManager(None, user)
    # Add Archetypes
    if not hasattr(aq_base(portal), 'archetype_tool'):
        portal.portal_quickinstaller.installProduct('Archetypes')
    # Add PloneLanguageTool
    if not hasattr(aq_base(portal), 'portal_languages'):
        portal.portal_quickinstaller.installProduct('PloneLanguageTool')
    # Add LinguaPlone
    if not hasattr(aq_base(portal.portal_skins), config.SKIN_NAME):
        portal.portal_quickinstaller.installProduct('LinguaPlone')
    # Log out
    noSecurityManager()
    get_transaction().commit()
    if not quiet: ZopeTestCase._print('done (%.3fs)\n' % (time.time()-start,))


ZopeTestCase.utils.appcall(setupLinguaPlone, portal_name, quiet=0)

