#ifndef _INCLUDED_GTKLIBRARY_H_
#define _INCLUDED_GTKLIBRARY_H_
#include <vector>

#include <time.h>
#include <sigc++/object.h>
#include <gtkmm/menu.h>

#include "event.h"
#include "facontext.h"
#include "playlist.h"
#include "musiccatalog.h"
#include "musiclayout.h"
#include "cataloginfo.h"

class GTKBrowserMusic;

class GTKLibrary : public SigC::Object {
 public:
	GTKLibrary(FAContext *context, PlaylistManager *plm, GTKBrowserMusic *musicbrowser);
	~GTKLibrary();
 
	Error AcceptEvent(Event *event);
	
	void set_layout(MusicLayout *layout);
	void SetPLM(PlaylistManager *plm) { m_plm = plm; }
	void DoEditTrack();
	void DoAddTrack();
	
	//Reimplemented Fucntions
	bool has_focus();
	
 private:
	//Internal Variables
	FAContext *m_context;
	PlaylistManager *m_plm;
	GTKBrowserMusic *m_musicbrowser;
 	bool m_PlayImmediately;
 
 	//Variables Used By Children
	time_t  m_last_change;	

	//Internal Functions
	void ReadPrefs();

 	void Playlist_AddItem(const std::string& URL);
	void Playlist_AddItems(const std::vector<std::string>& URLs);
	void Playlist_ReadPlaylist(const std::string& Playlist);
	
	//UI Event Functions
	void row_activated(CatalogInfo *catalog_info, bool force_playimmediately = false, bool force_onlyadd = false);
	void rows_activated(std::vector<CatalogInfo *> catalog_infos, bool force_playimmediately = false, bool force_onlyadd = false);
	
	//Menu Stuff
	Gtk::Menu m_catalogPopupMenu; //Popup Menu For Catalog Items 
    Gtk::Menu m_streamPopupMenu;
    Gtk::Menu m_cdPopupMenu;
	
	void on_menu_play();
	void on_menu_add();
	void on_menu_add_play();
	int menu_loc_remove;
	void on_menu_remove();
	int menu_loc_edit;
	void on_menu_edit();
	
	//Functions Called By GTKLibraryTree, GTKAlbumList, etc...
	void set_selection(std::vector<CatalogInfo *>& new_selection);
	std::vector<CatalogInfo *> selected_info;
		
	//Widgets/Classes For Different Views
	class GTKLibraryList;
	class GTKTrackList;
	class GTKAlbumList;
	class GTKLibraryTree;
	
	GTKTrackList *m_TrackList;
	GTKAlbumList *m_AlbumList;
	GTKLibraryTree *m_LibraryTree;
	
};

#endif
/* arch-tag: da56df3e-fe20-40d6-9fda-78fc5b0e185a */
