/*
 * Decompiled with CFR 0.152.
 */
package IceUtil;

import Ice.IntHolder;
import Ice.StringHolder;
import IceUtil.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public final class StringUtil {
    public static int findFirstOf(String string, String string2) {
        return StringUtil.findFirstOf(string, string2, 0);
    }

    public static int findFirstOf(String string, String string2, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) == -1) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstNotOf(String string, String string2) {
        return StringUtil.findFirstNotOf(string, string2, 0);
    }

    public static int findFirstNotOf(String string, String string2, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) continue;
            return i;
        }
        return -1;
    }

    private static void encodeChar(byte n, StringBuffer stringBuffer, String string) {
        switch (n) {
            case 92: {
                stringBuffer.append("\\\\");
                break;
            }
            case 39: {
                stringBuffer.append("\\'");
                break;
            }
            case 34: {
                stringBuffer.append("\\\"");
                break;
            }
            case 8: {
                stringBuffer.append("\\b");
                break;
            }
            case 12: {
                stringBuffer.append("\\f");
                break;
            }
            case 10: {
                stringBuffer.append("\\n");
                break;
            }
            case 13: {
                stringBuffer.append("\\r");
                break;
            }
            case 9: {
                stringBuffer.append("\\t");
                break;
            }
            default: {
                if (n < 32 || n > 126) {
                    stringBuffer.append('\\');
                    String string2 = Integer.toOctalString(n < 0 ? n + 256 : n);
                    for (int i = string2.length(); i < 3; ++i) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                    break;
                }
                if (string != null && string.indexOf((char)n) != -1) {
                    stringBuffer.append('\\');
                    stringBuffer.append((char)n);
                    break;
                }
                stringBuffer.append((char)n);
            }
        }
    }

    public static String escapeString(String string, String string2) {
        Object object;
        if (string2 != null) {
            for (int i = 0; i < string2.length(); ++i) {
                if (string2.charAt(i) >= ' ' && string2.charAt(i) <= '~') continue;
                throw new IllegalArgumentException("special characters must be in ASCII range 32-126");
            }
        }
        byte[] byArray = null;
        try {
            object = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            dataOutputStream.writeUTF(string);
            byArray = ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            Debug.Assert(false);
            return null;
        }
        object = new StringBuffer(byArray.length);
        for (int i = 2; i < byArray.length; ++i) {
            StringUtil.encodeChar(byArray[i], (StringBuffer)object, string2);
        }
        return ((StringBuffer)object).toString();
    }

    private static char checkChar(char c) {
        if (c < ' ' || c > '~') {
            throw new IllegalArgumentException("illegal input character");
        }
        return c;
    }

    private static char decodeChar(String string, int n, int n2, IntHolder intHolder) {
        int n3;
        Debug.Assert(n >= 0);
        Debug.Assert(n < n2);
        Debug.Assert(n2 <= string.length());
        if (string.charAt(n) != '\\') {
            n3 = StringUtil.checkChar(string.charAt(n++));
        } else {
            if (n + 1 == n2) {
                throw new IllegalArgumentException("trailing backslash in argument");
            }
            switch (string.charAt(++n)) {
                case '\"': 
                case '\'': 
                case '\\': {
                    n3 = string.charAt(n++);
                    break;
                }
                case 'b': {
                    ++n;
                    n3 = 8;
                    break;
                }
                case 'f': {
                    ++n;
                    n3 = 12;
                    break;
                }
                case 'n': {
                    ++n;
                    n3 = 10;
                    break;
                }
                case 'r': {
                    ++n;
                    n3 = 13;
                    break;
                }
                case 't': {
                    ++n;
                    n3 = 9;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int n4 = 0;
                    for (int i = 0; i < 3 && n < n2; ++i) {
                        int n5;
                        if ((n5 = string.charAt(n++) - 48) < 0 || n5 > 7) {
                            --n;
                            break;
                        }
                        n4 = n4 * 8 + n5;
                    }
                    if (n4 > 255) {
                        throw new IllegalArgumentException("octal value out of range");
                    }
                    n3 = (char)n4;
                    break;
                }
                default: {
                    n3 = StringUtil.checkChar(string.charAt(n++));
                }
            }
        }
        intHolder.value = n;
        return (char)n3;
    }

    private static void decodeString(String string, int n, int n2, StringBuffer stringBuffer) {
        IntHolder intHolder = new IntHolder();
        while (n < n2) {
            stringBuffer.append(StringUtil.decodeChar(string, n, n2, intHolder));
            n = intHolder.value;
        }
    }

    public static boolean unescapeString(String string, int n, int n2, StringHolder stringHolder) {
        if (n < 0) {
            throw new IllegalArgumentException("start offset must be >= 0");
        }
        if (n2 > string.length()) {
            throw new IllegalArgumentException("end offset must <= s.length()");
        }
        if (n > n2) {
            throw new IllegalArgumentException("start offset must <= end offset");
        }
        try {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            StringUtil.decodeString(string, n, n2, stringBuffer);
            String string2 = stringBuffer.toString();
            byte[] byArray = new byte[string2.length() + 2];
            for (n3 = 2; n3 < byArray.length; ++n3) {
                byArray[n3] = (byte)string2.charAt(n3 - 2);
            }
            n3 = new Integer(string2.length()).shortValue();
            byArray[0] = (byte)(n3 & 0xFF00);
            byArray[1] = (byte)(n3 & 0xFF);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            stringHolder.value = dataInputStream.readUTF();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int checkQuote(String string, int n) {
        char c = string.charAt(n);
        if (c == '\"' || c == '\'') {
            int n2;
            ++n;
            int n3 = string.length();
            while (n < n3 && (n2 = string.indexOf(c, n)) != -1) {
                if (string.charAt(n2 - 1) != '\\') {
                    return n2;
                }
                n = n2 + 1;
            }
            return -1;
        }
        return 0;
    }

    public static String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = StringUtil.findFirstNotOf(string, string2);
        int n2 = string.length();
        while (n != -1 && (n2 = StringUtil.findFirstOf(string, string2, n)) != -1) {
            vector.addElement(string.substring(n, n2));
            n = StringUtil.findFirstNotOf(string, string2, n2);
        }
        if (n != -1) {
            if (n2 == -1) {
                vector.addElement(string.substring(n));
            } else {
                vector.addElement(string.substring(n, n2));
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

