/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.ServiceInstanceDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.PlainService;
import IceGridGUI.Application.PropertySet;
import IceGridGUI.Application.Server;
import IceGridGUI.Application.Service;
import IceGridGUI.Application.ServiceInstanceEditor;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ServiceInstance
extends TreeNode
implements Service,
Cloneable {
    private ServiceInstanceDescriptor _descriptor;
    private String _displayString;
    private final boolean _ephemeral;
    private Utils.Resolver _resolver;
    private ServiceInstanceEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ServiceInstanceDescriptor copyDescriptor(ServiceInstanceDescriptor instanceDescriptor) {
        ServiceInstanceDescriptor copy = (ServiceInstanceDescriptor)instanceDescriptor.clone();
        copy.propertySet = PropertySet.copyDescriptor(copy.propertySet);
        if (copy.descriptor != null) {
            copy.descriptor = PlainService.copyDescriptor(copy.descriptor);
        }
        return copy;
    }

    public static List copyDescriptors(List descriptors) {
        LinkedList<ServiceInstanceDescriptor> copy = new LinkedList<ServiceInstanceDescriptor>();
        Iterator p = descriptors.iterator();
        while (p.hasNext()) {
            copy.add(ServiceInstance.copyDescriptor((ServiceInstanceDescriptor)p.next()));
        }
        return copy;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setLeafIcon(Utils.getIcon("/icons/16x16/service.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = true;
        if (((TreeNode)this._parent).getAvailableActions()[14]) {
            actions[14] = true;
        }
        actions[15] = true;
        if (this._parent instanceof Server && !this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
        }
        actions[18] = this.canMove(true);
        actions[19] = this.canMove(false);
        return actions;
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(18));
            _popup.add(actions.get(19));
        }
        actions.setTarget(this);
        return _popup;
    }

    public void copy() {
        this.getCoordinator().setClipboard(ServiceInstance.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public void moveUp() {
        this.move(true);
    }

    public void moveDown() {
        this.move(false);
    }

    public Object getDescriptor() {
        return this._descriptor;
    }

    public Object saveDescriptor() {
        ServiceInstanceDescriptor saved = (ServiceInstanceDescriptor)this._descriptor.clone();
        if (!$assertionsDisabled && saved.descriptor != null) {
            throw new AssertionError();
        }
        return saved;
    }

    public void restoreDescriptor(Object savedDescriptor) {
        ServiceInstanceDescriptor sd = (ServiceInstanceDescriptor)savedDescriptor;
        this._descriptor.template = sd.template;
        this._descriptor.parameterValues = sd.parameterValues;
        this._descriptor.propertySet = sd.propertySet;
    }

    public void destroy() {
        ((Communicator)this._parent).getServices().destroyChild(this);
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ServiceInstanceEditor)this.getRoot().getEditor(ServiceInstanceEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new ServiceInstanceEditor();
    }

    public String toString() {
        if (this._displayString != null) {
            return this._displayString;
        }
        return super.toString();
    }

    private boolean canMove(boolean up) {
        if (this._ephemeral) {
            return false;
        }
        return ((Communicator)this._parent).getServices().canMove(this, up);
    }

    private void move(boolean up) {
        if (!$assertionsDisabled && !this.canMove(up)) {
            throw new AssertionError();
        }
        ((Communicator)this._parent).getServices().move(this, up);
    }

    Editable getEnclosingEditable() {
        return ((Communicator)this._parent).getEnclosingEditable();
    }

    public Object rebuild(List editables) throws UpdateFailedException {
        ServiceInstance newService;
        Backup backup;
        block8: {
            backup = new Backup();
            if (this._descriptor.template.length() > 0) {
                TemplateDescriptor templateDescriptor = this.getRoot().findServiceTemplateDescriptor(this._descriptor.template);
                HashSet parameters = new HashSet(templateDescriptor.parameters);
                if (!((Object)parameters).equals(this._descriptor.parameterValues.keySet())) {
                    backup.parameterValues = this._descriptor.parameterValues;
                    this._descriptor.parameterValues = Editor.makeParameterValues(this._descriptor.parameterValues, templateDescriptor.parameters);
                    editables.add(this.getEnclosingEditable());
                }
            }
            Communicator communicator = (Communicator)this._parent;
            Communicator.Services services = communicator.getServices();
            newService = null;
            try {
                newService = (ServiceInstance)services.createChild(this._descriptor);
            }
            catch (UpdateFailedException e) {
                if (backup.parameterValues != null) {
                    this._descriptor.parameterValues = backup.parameterValues;
                }
                throw e;
            }
            try {
                backup.clone = (ServiceInstance)this.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        this.reset(newService);
        if (backup.parameterValues != null) {
            editables.add(this.getEnclosingEditable());
        }
        this.getRoot().getTreeModel().nodeChanged(this);
        return backup;
    }

    public void restore(Object backupObj) {
        Backup backup = (Backup)backupObj;
        if (backup.parameterValues != null) {
            this._descriptor.parameterValues = backup.parameterValues;
        }
        this.reset(backup.clone);
        this.getRoot().getTreeModel().nodeChanged(this);
    }

    private void reset(ServiceInstance from) {
        this._id = from._id;
        this._displayString = from._displayString;
        this._resolver = from._resolver;
    }

    ServiceInstance(Communicator parent, String name, String displayString, ServiceInstanceDescriptor instanceDescriptor, Utils.Resolver resolver) throws UpdateFailedException {
        super(parent, name);
        this._displayString = displayString;
        this._descriptor = instanceDescriptor;
        this._ephemeral = false;
        this._resolver = resolver;
    }

    ServiceInstance(Communicator parent, String name, ServiceInstanceDescriptor instanceDescriptor) {
        super(parent, name);
        this._descriptor = instanceDescriptor;
        this._ephemeral = true;
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            TemplateDescriptor templateDescriptor = this.getRoot().findServiceTemplateDescriptor(this._descriptor.template);
            LinkedList attributes = ServiceInstance.parameterValuesToAttributes(this._descriptor.parameterValues, templateDescriptor.parameters);
            attributes.addFirst(ServiceInstance.createAttribute("template", this._descriptor.template));
            if (this._descriptor.propertySet.references.length == 0 && this._descriptor.propertySet.properties.size() == 0) {
                writer.writeElement("service-instance", attributes);
            } else {
                writer.writeStartTag("service-instance", attributes);
                ServiceInstance.writePropertySet(writer, "", this._descriptor.propertySet, null);
                writer.writeEndTag("service-instance");
            }
        }
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    static {
        $assertionsDisabled = !ServiceInstance.class.desiredAssertionStatus();
    }

    private static class Backup {
        Map parameterValues;
        ServiceInstance clone;

        private Backup() {
        }
    }
}

