#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

int main(int argc, char *argv[])
{
	char *c = NULL, *fw_hdr_name = NULL;
	int fd, res, x;
	FILE *f = NULL;
	unsigned char buf[1024];

	/* Make sure we have the right amount of arguments */
	if (argc != 3) {
		fprintf(stderr, "Usage: fw2h <infile> <outfile>\n");
		exit(1);
	}

	/* Make sure we can open the firmware in file */
	if ((fd = open(argv[1], O_RDONLY)) < 0) {
		fprintf(stderr, "Unable to open '%s': %s\n", argv[1], strerror(errno));
		exit(1);
	}

	/* Make sure we can write out the firmware header file */
	if (!(f = fopen(argv[2], "w+"))) {
		fprintf(stderr, "Unable to open '%s' for writing: %s\n", argv[2], strerror(errno));
		exit(1);
	}

	/* Strip file extension */
	c = strrchr(argv[2], '.');
	if (c)
		*c = '\0';

	/* Now determine the firmware header name */
	c = strrchr(argv[2], '/');
	if (c)
		fw_hdr_name = ++c;
	else
		fw_hdr_name = argv[2];

	/* Write out the firmware as a header file */
	fprintf(f, "static unsigned char %s[] = {\t", fw_hdr_name);
	while ((res = read(fd, buf, sizeof(buf))) > 0) {
		for (x = 0; x < res; x++) {
			if (!(x % 16))
				fprintf(f, "\n\t");
			fprintf(f, "0x%02x, ", buf[x]);
		}
	}
	fprintf(f, "\n};\n");

	if (res < 0) {
		fprintf(stderr, "Error reading file: %s\n", strerror(errno));
		exit(1);
	}

	fclose(f);
	close(fd);
	exit(0);
}
