/*
                      YIFF Configuration Wizard

        Copyright (C) 1997-2003 WolfPack Entertainment
 */

#ifndef YC_H
#define YC_H

#include <sys/types.h>
#include <gtk/gtk.h>

#include "../include/Y2/Y.h"
#include "../include/Y2/Ylib.h"

#include "fb.h"
#include "pstepper.h"

#ifndef gbool
# define gbool	boolean
#endif


/*
 *	Program name and version:
 */
#define PROG_NAME	"YIFF Configuration Wizard"
#define PROG_VERSION	"2.14.2"

#define PROG_VERSION_MAJOR	2
#define PROG_VERSION_MINOR	14
#define PROG_VERSION_RELEASE	2


/*
 *      Program copyright:
 */
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2003 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law."

/*
 *	Program help message:
 */
#define PROG_HELP_MESG "\
Usage: yiffconfig [options] [GUI_options]\n\
\n\
    [options] can be any of the following:\n\
\n\
        -f <file>               Specifies the configuration file.\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult your\n\
    GUI's manual for available options.\n\
\n"


/*
 *	Styles for use with GTK widgets:
 */
typedef struct {

	GtkStyle	*standard,	/* Never destroy this one, comes
					 * from GTK.
					 */
			*heading1_text,
			*heading2_text,
			*heading3_text,
			*heading4_text,
			*heading5_text,
			*heading6_text,
			*nariative_text;

} yc_styles_struct;

/*
 *	Pixmaps for use with GTK, each pixmap has a GdkPixmap and an
 *	associated GdkBitmap (for the mask):
 */
typedef struct {

	GdkPixmap	*nariative_bg;
	GdkBitmap	*nariative_bg_mask;

        GdkPixmap       *title;
        GdkBitmap       *title_mask;

	GdkPixmap	*icon_yiff_48x48;
	GdkBitmap	*icon_yiff_48x48_mask;

        GdkPixmap       *icon_yiff_32x32;
        GdkBitmap       *icon_yiff_32x32_mask;

        GdkPixmap       *icon_wand_32x32;
        GdkBitmap       *icon_wand_32x32_mask;


} yc_pixmaps_struct;


/*
 *	Data structure for a Y Audio Mode:
 */
typedef struct {

	/* This struct is gonna be the same as YAudioModeValuesStruct
	 * with the exception that member name is dynamically
	 * allocated.
	 */

	gchar *name;

	gint sample_rate;		/* In Hz. */
	gint channels;			/* 1 or 2. */
        gint sample_size;		/* 8 or 16. */
        gint fragment_size_bytes;	/* In bytes. */
	gint direction;
	gbool allow_fragmenting;	/* True if fragmenting allowed. */
	gint num_fragments;		/* Number of fragments. */

	gbool flip_stereo;

	glong cycle_us;			/* In microseconds. */
        glong write_ahead_us;		/* In microseconds. */

} yc_ymode_data_struct;


/*
 *	Page numbers, these must be from 0 to one less than YC_PAGES_MAX:
 */
#define YC_PAGE_NUM_WELCOME		0
#define YC_PAGE_NUM_LOCATIONS		1	/* Paths, address, port... */
#define YC_PAGE_NUM_YMODES		2	/* Y Audio modes. */
#define YC_PAGE_NUM_TIMINGS		3	/* Ie refresh interval. */
#define YC_PAGE_NUM_MIDI		4
#define YC_PAGE_NUM_YSOUNDPATHS		5	/* YSound paths. */
#define YC_PAGE_NUM_CONFERM		6	/* Confermations page. */
#define YC_PAGE_NUM_FINISHED		7

/*
 *	Total number of pages:
 */
#define YC_PAGES_MAX	8


/*
 *	Main window structure:
 */
typedef struct {

	gbool initialized;
	gbool show_tool_tips;
	gbool has_changes;

	/* Connection to Y sound server. */
	YConnection *recorder;

	/* Default file browser file extension types list. */
	fb_type_struct **ftype;
	gint total_ftypes;

	/* Page stepper widget. */
	pstepper_struct *ps;


	/* These are the widgets for each nariative strip. */

	/* ...none for now. */


	/* These are the widgets for each page. */
	/* On page YC_PAGE_NUM_WELCOME... */
	/* On page YC_PAGE_NUM_LOCATIONS... */
	GtkWidget *yiff_configuration_file_entry;
	GtkWidget *yiff_configuration_file_browse;	/* Browse button. */
	GtkWidget *yiff_program_entry;
	GtkWidget *yiff_program_browse;			/* Browse button. */
	GtkWidget *dsp_device_entry;
	GtkWidget *dsp_device_browse;			/* Browse button. */
	GtkWidget *mixer_device_entry;
	GtkWidget *mixer_device_browse;			/* Browse button. */
	GtkWidget *address_entry;
	GtkWidget *port_entry;
	GtkWidget *yiff_start_toggle;		/* Start yiff server? */
	/* On page YC_PAGE_NUM_YMODES... */
	GtkWidget *ymodes_clist;	/* Loaded Y modes stored here. */
	GtkWidget *ymodes_menu;
        GtkWidget *ymodes_menu_add;
        GtkWidget *ymodes_menu_edit;
        GtkWidget *ymodes_menu_remove;
	GtkWidget *ymode_add_btn;
	GtkWidget *ymode_edit_btn;
	GtkWidget *ymode_remove_btn;
	GtkWidget *ymode_shift_up_btn;
	GtkWidget *ymode_shift_down_btn;
	GtkWidget *ymode_sample_rate_combo;	/* In Hz. */
	GtkWidget *ymode_fragment_size_combo;	/* In bytes. */
        GtkWidget *ymode_channels1_radio;
	GtkWidget *ymode_channels2_radio;
	GtkWidget *ymode_sample_size8_radio;
	GtkWidget *ymode_sample_size16_radio;
	GtkWidget *ymode_cycle_spin;		/* In microseconds. */
	GtkWidget *ymode_calculate_cycle_btn;
	GtkWidget *ymode_apply_to_yiff_btn;
	GtkWidget *ymode_play_btn;		/* Play a DSP sound. */
	/* On page YC_PAGE_NUM_TIMINGS... */
	GtkWidget *sound_refresh_spin;		/* In microseconds. */
	/* On page YC_PAGE_NUM_MIDI... */
	GtkWidget *midi_play_cmd_entry;		/* Command to play midi. */
	GtkWidget *midi_play_cmd_browse;	/* Browse button. */
	GtkWidget *alsa_midi_port_entry;	/* MIDI port number (ALSA only). */
	/* On page YC_PAGE_NUM_YSOUNDPATHS... */
	GtkWidget *ysound_paths_clist;		/* YSound paths stored here. */
	GtkWidget *ysound_paths_menu;
	GtkWidget *ysound_paths_menu_add;
	GtkWidget *ysound_paths_menu_edit;
	GtkWidget *ysound_paths_menu_remove;
	GtkWidget *ysound_paths_add_btn;
	GtkWidget *ysound_paths_edit_btn;
	GtkWidget *ysound_paths_remove_btn;
	GtkWidget *ysound_paths_shift_up_btn;
	GtkWidget *ysound_paths_shift_down_btn;
	/* On page YC_PAGE_NUM_CONFERM... */
	GtkWidget *conferm_items_clist;
	GtkWidget *conferm_verbose_toggle;
	GtkWidget *start_script_entry;
	GtkWidget *start_script_browse;


	/* Currently selected ymode item (row) number. */
	gint selected_ymode;

	/* Currently selected ysound path item (row) number. */
	gint selected_ysound_path;

	/* Sound object currently being played (can be NULL). */
	YID current_sound_play;


} yc_struct;


/*
 *	Core structure:
 */
typedef struct {

	yc_styles_struct yc_styles;
	yc_pixmaps_struct yc_pixmaps;
	yc_struct yc;

} yc_core_struct;


/* In main.c */
extern gint YCInit(yc_core_struct *core_ptr, gint argc, gchar **argv);
extern gint YCManage(gpointer data);
extern void YCShutdown(yc_core_struct *core_ptr);

/* In yc.c */
extern int YCCreate(
	yc_struct *yc,
	yc_styles_struct *styles, yc_pixmaps_struct *pixmaps
);
extern void YCYModesListDeleteAll(yc_struct *yc);
extern void YCYSoundPathsListDeleteAll(yc_struct *yc);
extern void YCMap(yc_struct *yc);
extern void YCUnmap(yc_struct *yc);
extern void YCDestroy(yc_struct *yc);

/* In yccb.c */
extern void YCSignalCB(int s);
extern void YCPSPageChangeCB(
	gpointer ps_ptr, gint prev_page, gint new_page, gpointer data
);
extern void YCPSExitCB(gpointer ps_ptr, gint cur_page, gpointer data);
extern void YCPSFinishCB(gpointer ps_ptr, gint cur_page, gpointer data);

extern gint YCWidgetExposeCB(
        GtkWidget *widget, GdkEventExpose *event, gpointer data
);

extern void YCBrowseConfigurationFileCB(void *widget, void *data);
extern void YCBrowseYIFFProgramCB(void *widget, void *data);
extern void YCBrowseDSPDeviceCB(void *widget, void *data);
extern void YCBrowseMixerDeviceCB(void *widget, void *data);

extern gint YCYModesListMenuMapCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
);
extern void YCYModesListSelectCB(
        GtkWidget *widget, gint row, gint column,
        GdkEventButton *event, gpointer data
);
extern void YCYModesListButtonCB(GtkWidget *widget, gpointer data);
extern void YCCycleCalculateCB(GtkWidget *widget, gpointer data);
extern void YCCycleSpinChangeCB(GtkWidget *widget, gpointer data);
extern void YCYModeValuesApplyToYCB(GtkWidget *widget, gpointer data);
extern void YCYModePlayCB(GtkWidget *widget, gpointer data);
extern void YCRefreshIntSpinChangeCB(GtkWidget *widget, gpointer data);

extern void YCBrowseMIDIPlayCmdCB(void *widget, void *data);

extern gint YCYSoundPathsMenuMapCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
);
extern void YCYSoundPathsListSelectCB(
        GtkWidget *widget, gint row, gint column,
        GdkEventButton *event, gpointer data
);
extern void YCYSoundPathsListButtonCB(GtkWidget *widget, gpointer data);

extern void YCConfermationListSelectCB(
	GtkWidget *widget, gint row, gint column,
        GdkEventButton *event, gpointer data
);
extern void YCConfermVerboseToggleCB(GtkWidget *widget, gpointer data);
extern void YCBrowseStartScriptCB(void *widget, void *data);


/* In ycfile.c */
extern int YCLoadConfiguration(yc_struct *yc, const char *filename);
extern int YCSaveConfiguration(yc_struct *yc, const char *filename);

extern int YCSaveStartScript(yc_struct *yc, const char *filename);


/* In ycpagechange.c */
extern void YCPageChange(yc_struct *yc, gint prev_page, gint new_page);


/* In ycutils.c */
extern yc_ymode_data_struct *YCYModeDataStructNew(void);
extern void YCYModeDataStructFree(yc_ymode_data_struct *ymode_data_ptr);

extern void YCYModeFetchFromWidgets(
	yc_struct *yc, yc_ymode_data_struct *buf
);
extern void YCYModeSetToWidgets(yc_struct *yc, yc_ymode_data_struct *buf);

extern void YCConfermListRefresh(yc_struct *yc);

extern int YCCheckInstallation(
        yc_struct *yc,
        const gchar *configuration_file,
        const gchar *yiff_program,
        gbool report_problems
);


#endif	/* YC_H */
