#ifndef GUIUTILS_H
#define GUIUTILS_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Menu item default height:
 */
#define GUI_MENU_ITEM_DEF_HEIGHT	20

/*
 *	Menu item type codes:
 */
#define GUI_MENU_ITEM_TYPE_LABEL	0
#define GUI_MENU_ITEM_TYPE_CHECK	1
#define GUI_MENU_ITEM_TYPE_SEPARATOR	2
#define GUI_MENU_ITEM_TYPE_SUBMENU	3

/*
 *	Menu bar item alignments:
 */
#define GUI_MENU_BAR_ALIGN_LEFT		0
#define GUI_MENU_BAR_ALIGN_RIGHT	1
#define GUI_MENU_BAR_ALIGN_CENTER	2


extern void *GUICreateMenuItemIcon(u_int8_t **icon);

extern void GUIGetWindowRootPosition(
        void *w, int *x, int *y
);

extern void *GUICreateCursorFromData(
        u_int8_t **cursor_data,
        double hot_x, double hot_y,
        int width, int height   /* Both can be 0. */
);
extern void GUISetWMIcon(GdkWindow *w, u_int8_t **icon);
extern void GUISetWidgetTip(void *w, const char *tip);
extern void GUIShowTipsNow(void *w);
extern void GUISetGlobalTipsState(int state);

extern void GUIButtonChangeLayout(
	void *button, int show_pixmap, int show_label
);
extern void *GUIButtonPixmap(u_int8_t **icon);
extern void *GUIButtonPixmapLabelH(
	u_int8_t **icon, const char *label, void **label_rtn
);
extern void *GUIButtonPixmapLabelV(
	u_int8_t **icon, const char *label, void **label_rtn
);

extern void *GUIToggleButtonPixmap(u_int8_t **icon);
extern void *GUIToggleButtonPixmapLabelH(
	u_int8_t **icon, const char *label, void **label_rtn
);
extern void *GUIToggleButtonPixmapLabelV(
	u_int8_t **icon, const char *label, void **label_rtn
);

extern void *GUIPromptBarWithBrowse(
        u_int8_t **icon, const char *label,
        void **label_rtn, void **entry_rtn, void **browse_rtn,
        void *browse_client_data, void (*browse_cb)(void *, void *)
);
extern void *GUIPromptBar(          
        u_int8_t **icon, const char *label,
        void **label_rtn, void **entry_rtn                   
);

extern void GUIDNDSetSrc(
        void *w, void *drag_type, int ndrag_types,
        unsigned int actions, unsigned int buttons,
        void (*begin_cb)(GtkWidget *, GdkDragContext *, gpointer),
        void (*request_data_cb)(GtkWidget *, GdkDragContext *,
                GtkSelectionData *, guint, guint, gpointer),
        void (*delete_data_cb)(GtkWidget *, GdkDragContext *, gpointer),
        void (*end_cb)(GtkWidget *, GdkDragContext *, gpointer),
        gpointer client_data
);
extern void GUIDNDSetTar(
        void *w, void *drag_type, int ndrag_types,
        unsigned int actions, unsigned int default_action_same,
        unsigned int default_action,
        void (*recieved_data_cb)(GtkWidget *, GdkDragContext *,
                gint, gint, GtkSelectionData *, guint, guint,
                gpointer  
        ),
        gpointer client_data
);
extern void GUIDNDSetDragIcon(void *pixmap, void *mask);

void *GUIBannerCreate(
        const char *label,
        void *style,		/* Can be NULL. */
        int align,		/* One of GTK_JUSTIFY_*. */
        gbool expand
);

extern void *GUIComboCreate(
        const char *label,
        const char *text,       /* Initial text. */
        void *list,             /* Initial glist of items for combo list. */
        int max_items,          /* Maximum items allowed. */
        void **combo_rtn,	/* Combo widget return. */
        void *client_data,
        void (*func_cb)(GtkWidget *w, void *),
        void (*list_change_cb)(GtkWidget *, void *, GList *)
);
extern void GUIComboActivateValue(void *w, const char *value);
extern void GUIComboAddItem(void *w, const char *value);
extern void *GUIComboGetList(void *w);
extern void GUIComboSetList(void *w, void *list);
extern void GUIComboClearAll(void *w);

extern void *GUIMenuBarCreate(void **accel_group);
extern void *GUIMenuCreate(void);
extern void *GUIMenuItemCreate(
	void *menu, int type,	/* One of GUI_MENU_ITEM_TYPE_*. */
	void *accel_group,
	u_int8_t **icon, const char *label,
	int accel_key, unsigned int accel_mods,
	void **functional_widget_rtn,
        void *client_data,
        void (*func_cb)(GtkWidget *w, void *)
);
extern void *GUIMenuAddToMenuBar(
	void *menu_bar, void *menu,
	const char *menu_bar_item_label,
	int align	/* One of GUI_MENU_BAR_ALIGN_*. */
);
extern void *GUIMenuAddToMenuBarPixmapH(
        void *menu_bar, void *menu,
        const char *menu_bar_item_label, const u_int8_t **icon,
        int align       /* One of GUI_MENU_BAR_ALIGN_*. */
);
extern void GUIMenuItemSetSubMenu(
        void *menu_item, void *sub_menu
);

extern void *GUIPullOutCreateH(
        void *parent_box,
        int homogeneous, int spacing,           /* Of client vbox. */
        int expand, int fill, int padding,      /* Of holder hbox. */
        int toplevel_width, int toplevel_height,
        void *pull_out_client_data,
        void (*pull_out_cb)(void *, void *),
        void *push_in_client_data,
        void (*push_in_cb)(void *, void *)
);
extern void *GUIPullOutGetToplevelWindow(
        void *client_box,
        int *x, int *y, int *width, int *height
);
extern void GUIPullOutPullOut(void *client_box);
extern void GUIPullOutPushIn(void *client_box);


#endif	/* GUIUTILS_H */
