/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#include <iostream>

#include <sigc++/method_slot.h>
#include <sigc++/retype_return.h>

#include <sigcx/tunnel.h>
#include <sigcx/dispatch.h>
#include <sigcx/gtk_dispatch.h>

#include "yehia/plugin.h"
#include "yehia/script.h"

namespace
{

using namespace SigC;
using namespace SigCX;

//
// Yehia Script interface for namespace yehia
//
void yehia_ns_yehia_register(Yehia::Script::Language& lang)
{
  using namespace Yehia::Script;
  using SigC::retype_return;
  using SigC::slot;
  
  ObjectFactory& factory = lang.factory();
  Signature bases;
  
  NamespaceBuilder nsyehia(factory, lang.root_namespace(), "yehia");
  
  bases.erase(bases.begin(), bases.end());
  bases.push_back(&typeid(Dispatcher));
  ClassBuilder<GtkDispatcher> clGtkDispatcher(factory, nsyehia, "GtkDispatcher", bases);
  clGtkDispatcher.constructor(Constructor0<GtkDispatcher>());
}

//
// Plugin 'yehia_gtk'
//
class yehia_gtkPlugin : public Yehia::Plugin
{
  public:
    yehia_gtkPlugin(Yehia::PluginManager& mgr) : Plugin(mgr) {
      using namespace Yehia::Script;
      std::list<Language *> langs = LanguageManager::instance().languages();
      
      for (std::list<Language *>::iterator it = langs.begin();
           it != langs.end(); ++it)
      {
        SigCX::tunnel<void, Yehia::Script::Language&>(slot(&yehia_ns_yehia_register), **it, (**it).tunnel());
      }
      LanguageManager::instance().language_registered.connect(SigC::slot(*this, &yehia_gtkPlugin::got_new_language));
    }
    virtual std::string description() const { return "Yehia GTK+ scripting support"; }
    void got_new_language(const std::string& name) {
      using namespace Yehia::Script;
      Language *lang = LanguageManager::instance().language(name);
      if (lang)
      {
        SigCX::tunnel<void, Yehia::Script::Language&>(slot(&yehia_ns_yehia_register), *lang, (*lang).tunnel());
      }
    }
};

extern "C" Yehia::Plugin *yehia_yehia_gtk_plugin_init(Yehia::PluginManager *mgr)
{
  try
  {
    mgr->load_plugin("yehia");
    Yehia::Plugin *plugin = SigC::manage(new yehia_gtkPlugin(*mgr));
    plugin->reference();
    return plugin;
  }
  catch (...)
  {
    mgr->set_error("yehia_gtkPlugin initialisation failed");
    return 0;
  }
}


}

