/*
 * GtkSpell.c
 */

/*
 * yank  -  yet another NoteKeeper
 * Copyright (C) 1999, 2000, 2001 Michael Humann <m.hussmann@home.ins.de>
 *
 * This program is free software; you  can redistribute it and/or modify it
 * under the terms of  the GNU General  Public License as published  by the
 * Free Software Foundation;  either version 2 of  the License, or (at your
 * option) any later version.
 *
 * This program  is  distributed in the  hope  that it will  be useful, but
 * WITHOUT  ANY   WARRANTY;  without   even   the  implied    warranty   of
 * MERCHANTABILITY or    FITNESS FOR A PARTICULAR   PURPOSE.   See  the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write to the  Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "plugindefs.h"
#include "gtkspell.h"

extern GtkWidget         *yank_main_app(GtkWidget *);
extern GtkWindow         *yank_root_win(GtkWindow *);
extern gchar             *yank_plugin_menu_path(void);
extern void              set_status_text(const gchar *);

extern GtkWidget         *text_entry;

static void              cb_gtkspell_dialog(GtkWidget *, gpointer);
static gint              destructor(plugin_list_entry **);

static plugin_func_basic my_functions =
{
    &(destructor),
    NULL
};

static gchar             name[]      = N_("GtkSpell");
static e_plugin_type     plugin_type = PLUGIN_BASIC;
static plugin_list_entry *list_entry = NULL;

static GtkWidget         *rb_ispell;
static GtkWidget         *rb_aspell;
static GtkWidget         *rb_stop;
static GtkWidget         *d_entry = NULL;
static gchar             *menu_base_txt = NULL;
static gchar             menu_entry_txt[] = N_("GtkSpell...");
static GnomeUIInfo       gpg_menu [] =
{
    {
        GNOME_APP_UI_ITEM, menu_entry_txt, N_("instant spell checking"),
        cb_gtkspell_dialog, NULL, NULL, 0, 0, (gchar)NULL, GDK_CONTROL_MASK
    },
    GNOMEUIINFO_END
};

/* ------------------------------------------------------ */
/*
 * init plugin
 */

gint
constructor(plugin_list_entry **entry)
{
    gint ret;
    
    ret = 0;

    (*entry)->uses = 1;                    /* just loaded */
    (*entry)->func = NULL;
    list_entry = (*entry);
    list_entry->func = &my_functions;
    
    /* install menu */
    menu_base_txt = g_strdup_printf("%s/", yank_plugin_menu_path());
    gnome_app_insert_menus(GNOME_APP(yank_main_app(NULL)), menu_base_txt,
                           gpg_menu);
    
    return (ret);
}

/* ------------------------------------------------------ */
/*
 * destroy plugin
 */

gint
destructor(plugin_list_entry **entry)
{
    gchar *menu;
    gint  ret;

    ret = 0;

    if ((*entry)->uses == 1)
    {
        /* uninstall menu */
        menu = g_strconcat(menu_base_txt, menu_entry_txt, NULL);
        gnome_app_remove_menus(GNOME_APP(yank_main_app(NULL)), menu, 1);
        g_free(menu_base_txt);
        g_free(menu);
        (*entry)->uses = 0;
        list_entry = NULL;
    }
    else
    {
        ret = 1;
    }
    
    if (gtkspell_running())
    {
        gtkspell_detach(GTK_TEXT(text_entry));
        gtkspell_stop();
        set_status_text(_("Spellchecker stopped"));
    }

    return (ret);
}
              
/* ------------------------------------------------------ */
/*
 * tell name
 */

gchar*
return_name(void)
{
    return (name);
}

/* ------------------------------------------------------ */
/*
 * tell type
 */

e_plugin_type
return_plugin_type(void)
{
    return (plugin_type);
}

/* ------------------------------------------------------ */
/*
 * inc reference
 */

static void
use_me(plugin_list_entry *entry)
{
    entry->uses++;
}

/* ------------------------------------------------------ */
/*
 * dec reference
 */

static void
unuse_me(plugin_list_entry *entry)
{
    entry->uses--;
}

/* ------------------------------------------------------ */
/*
 * close the gtkspell dialog (by destroying it)
 */

static void
cb_gtkspell_close(GtkWidget *w, gpointer p)
{
    gtk_widget_hide(GTK_WIDGET(p));
    gtk_widget_destroy(GTK_WIDGET(p));
}

/* ------------------------------------------------------ */
/*
 * start/ stop gtkspell
 */

static void
cb_gtkspell_ok(GtkWidget *w, gpointer p)
{
    gchar    *txt;
    gboolean use_ispell;
    gchar    *spell_cmd[5];
    
    if (gtkspell_running())
    {
        unuse_me(list_entry);
        gtkspell_detach(GTK_TEXT(text_entry));
        gtkspell_stop();
        set_status_text(_("Spellchecker stopped"));
    }

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rb_stop)))
    {
        cb_gtkspell_close(w, p);
        return;
        /* notreached */
    }

    use_ispell = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rb_ispell));

    spell_cmd[0] = use_ispell ? "ispell" : "aspell";
    spell_cmd[1] = use_ispell ? "-a"     : "pipe";

    txt = gtk_entry_get_text(GTK_ENTRY(gnome_entry_gtk_entry(
        GNOME_ENTRY(d_entry))));

    if (strlen(txt) == 0)
    {
        spell_cmd[2] = NULL;
    }
    else
    {
        spell_cmd[2] = use_ispell ? "-d" : "--lang";
        spell_cmd[3] = txt;
        spell_cmd[4] = NULL;
    }
    
    if (gtkspell_start(NULL, spell_cmd) == 0)
    {
        gtkspell_attach(GTK_TEXT(text_entry));
        txt = g_strdup_printf(_("Starting %s"), spell_cmd[0]);
        set_status_text(txt);
        g_free(txt);
        use_me(list_entry);
    }
    else
    {
        txt = g_strdup_printf(_("Can't start %s"), spell_cmd[0]);
        set_status_text(txt);
        g_free(txt);
    }

    cb_gtkspell_close(w, p);
}

/* ------------------------------------------------------ */
/*
 * kill the gtkspell dialog
 */

static void
cb_gtkspell_destroy(GtkWidget *w, gpointer p)
{
    unuse_me(list_entry);
    p = NULL;
}

/* ------------------------------------------------------ */
/*
 * draw the gtkspell dialog
 */

static void
cb_gtkspell_dialog(GtkWidget *w, gpointer p)
{
    static GtkWidget *dialog = NULL;
    gchar            *title;
    GtkWidget        *dialog_vbox;
    GtkWidget        *hbox1;
    GtkWidget        *frame1;
    GtkWidget        *vbox2;
    GSList           *spell_group = NULL;
    GtkWidget        *hbox2;
    GtkWidget        *accellabel1;
    GtkWidget        *hbox6;
    GtkWidget        *label3;
    GtkWidget        *label4;
    GtkWidget        *frame2;
    GtkWidget        *vbox3;
    GtkWidget        *hbox3;
    GtkWidget        *label1;
    GtkWidget        *hbox5;
    GtkWidget        *href1;
    GtkWidget        *hbox4;
    GtkWidget        *label2;
    

    use_me(list_entry);
    
    title = g_strdup_printf(_("%s - %s"), PACKAGE, name);
    dialog = gnome_dialog_new(title, GNOME_STOCK_BUTTON_OK,
                              GNOME_STOCK_BUTTON_CANCEL, NULL);
    g_free(title);
    gnome_dialog_set_parent(GNOME_DIALOG(dialog), yank_root_win(NULL));
    
    dialog_vbox = GNOME_DIALOG(dialog)->vbox;
 
    frame1 = gtk_frame_new(_("GtkSpell Options"));
    gtk_box_pack_start(GTK_BOX(dialog_vbox), frame1, TRUE, TRUE, 2);
    gtk_container_set_border_width(GTK_CONTAINER(frame1), 2);

    vbox2 = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(frame1), vbox2);
    gtk_container_set_border_width(GTK_CONTAINER(vbox2), 2);

    hbox1 = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox2), hbox1, TRUE, TRUE, 0);

    rb_ispell = gtk_radio_button_new_with_label(spell_group, _("ispell"));
    spell_group = gtk_radio_button_group(GTK_RADIO_BUTTON(rb_ispell));
    gtk_box_pack_start(GTK_BOX(hbox1), rb_ispell, FALSE, FALSE, 0);
    
    rb_aspell = gtk_radio_button_new_with_label(spell_group, _("aspell"));
    spell_group = gtk_radio_button_group(GTK_RADIO_BUTTON(rb_aspell));
    gtk_box_pack_start(GTK_BOX(hbox1), rb_aspell, FALSE, FALSE, 0);
    
    rb_stop = gtk_radio_button_new_with_label(spell_group, _("Stop"));
    spell_group = gtk_radio_button_group(GTK_RADIO_BUTTON(rb_stop));
    gtk_box_pack_start(GTK_BOX(hbox1), rb_stop, FALSE, FALSE, 0);
    
    hbox2 = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox2), hbox2, FALSE, FALSE, 0);
    
    accellabel1 = gtk_label_new(_("Dictionary"));
    gtk_box_pack_start(GTK_BOX(hbox2), accellabel1, FALSE, FALSE, 0);
    
    d_entry = gnome_entry_new("gtkspell dictionary");
    gtk_box_pack_start(GTK_BOX(hbox2), d_entry, TRUE, TRUE, 0);
    
    hbox6 = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox2), hbox6, TRUE, TRUE, 0);
    
    label3 = gtk_label_new(_("Spellchecker is running:"));
    gtk_box_pack_start(GTK_BOX(hbox6), label3, FALSE, FALSE, 0);

    if (gtkspell_running())
    {
        label4 = gtk_label_new(_("Yes"));
    }
    else
    {
        label4 = gtk_label_new(_("No"));
    }
    
    gtk_box_pack_start(GTK_BOX(hbox6), label4, FALSE, FALSE, 0);
    
    frame2 = gtk_frame_new(_("About"));
    gtk_box_pack_start(GTK_BOX(dialog_vbox), frame2, TRUE, TRUE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(frame2), 2);
    
    vbox3 = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(frame2), vbox3);
    gtk_container_set_border_width(GTK_CONTAINER(vbox3), 2);
    
    hbox3 = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox3), hbox3, TRUE, TRUE, 0);
    
    label1 = gtk_label_new(_("Spellchecking code comes from: "));
    gtk_box_pack_start(GTK_BOX(hbox3), label1, FALSE, FALSE, 0);
    
    hbox5 = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox3), hbox5, FALSE, FALSE, 0);
    
    href1 = gnome_href_new("http://gtkspell.sourceforge.net/",
                            _("gtkspell.sourceforge.net"));
    gtk_box_pack_start(GTK_BOX(hbox5), href1, FALSE, FALSE, 0);
    
    hbox4 = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox3), hbox4, FALSE, FALSE, 0);
    
    label2 = gtk_label_new(_("Mouse 2 gives suggestions."));
    gtk_box_pack_start(GTK_BOX(hbox4), label2, FALSE, FALSE, 0);
    
    gnome_dialog_button_connect(GNOME_DIALOG(dialog), 0,
                                GTK_SIGNAL_FUNC(cb_gtkspell_ok),
                                dialog);
    gnome_dialog_button_connect(GNOME_DIALOG(dialog), 1,
                                GTK_SIGNAL_FUNC(cb_gtkspell_close),
                                dialog);
    gtk_signal_connect(GTK_OBJECT(dialog), "destroy",
                       GTK_SIGNAL_FUNC(cb_gtkspell_destroy), dialog);
    
    gnome_dialog_set_default(GNOME_DIALOG(dialog), 0);
    gtk_widget_show_all(dialog);
}

/* ------------------------------------------------------ */
