/***************************************************************************
authldap is written by Ahmad S. Al-rasheedan alrasheedan@yahoo.com 
Feb. 2000. It is meant to be used in conjunction with Xtradius as an
authentication plugiin.
I hope it does not break anything on your computer.
--
Ahmad S. Al-rasheedan (alrasheedan@yahoo.com)
***************************************************************************/


#include "authldap.h"


int main(int argc,char *argv[])
{
authldap(argc, argv[1], argv[2]);
}


int authldap(int x, char *login,char *password)
{
LDAP *ld;
char *host = LDAP_HOST;
char *dn;
char *pw = password;
int command_length;


int rc;
if ( ( ld = ldap_init( host, LDAP_PORT ) ) == NULL ) { 
   perror( "ldap_init" );
   return( 1 );
}


/* Lets allocate some memory for the command */


command_length = strlen(LDAP_COMMAND) + strlen(login) + strlen(GROUP) +
 strlen(ORG) + 1;   /* add extra byte for NULL termination */
 dn = (char *) malloc(command_length*sizeof(char));
  if (!dn)
   {
    printf("Memory request failed");
     exit(1);
    }


  sprintf(dn, "uid=%s, ou=%s, o=%s", login, GROUP, ORG);


/* Lets try to bind to LDAP server using given login name and password */


   rc = ldap_simple_bind_s( ld, dn, pw );
    free(dn);
     if ( rc == 0)
      {
        printf("%d", AUTH_OK);  /* So you can see something in your log */
        ldap_unbind(ld);
        return(AUTH_OK);
      }
        else
        {
        printf("%d", BAD_AUTH); /* So you can see something in your log */
        ldap_unbind(ld);
        return(BAD_AUTH);
        }
} 