/* $Id: Settings.cc,v 1.3 2000/08/30 22:56:22 dave Exp $ */
/*  Settings  XTide global settings

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.hh"

Settings::Settings() {
  gw_isnull = gh_isnull = ga_isnull = cw_isnull = lw_isnull = gl_isnull =
    tw_isnull = th_isnull = 1;
}

char
*Settings::settingsid() {
  return "generic settings";
}

void
Settings::supersedeBy (const Settings &sup) {
  int a;
  for (a=0; a<numcolors; a++)
    if (!(sup.colors[a].isNull()))
      colors[a] = sup.colors[a];
  if (!(sup.el.isNull()))
    el = sup.el;
  if (!(sup.u.isNull()))
    u = sup.u;
  if (!(sup.z.isNull()))
    z = sup.z;
  if (!(sup.df.isNull()))
    df = sup.df;
  if (!(sup.hf.isNull()))
    hf = sup.hf;
  if (!(sup.tf.isNull()))
    tf = sup.tf;
  if (!(sup.tl.isNull()))
    tl = sup.tl;
  if (!(sup.nf.isNull()))
    nf = sup.nf;
  if (!(sup.ns.isNull()))
    ns = sup.ns;
  if (!(sup.gw_isnull)) {
    gw_isnull = 0;
    gw = sup.gw;
  }
  if (!(sup.tw_isnull)) {
    tw_isnull = 0;
    tw = sup.tw;
  }
  if (!(sup.th_isnull)) {
    th_isnull = 0;
    th = sup.th;
  }
  if (!(sup.lw_isnull)) {
    lw_isnull = 0;
    lw = sup.lw;
  }
  if (!(sup.gh_isnull)) {
    gh_isnull = 0;
    gh = sup.gh;
  }
  if (!(sup.ga_isnull)) {
    ga_isnull = 0;
    ga = sup.ga;
  }
  if (!(sup.cw_isnull)) {
    cw_isnull = 0;
    cw = sup.cw;
  }
  if (!(sup.gl_isnull)) {
    gl_isnull = 0;
    gl = sup.gl;
  }
}

double
Settings::getdouble (char *val) {
  double temp;
  if (!val) {
    Dstr details ("The offending input in ");
    details += settingsid();
    details += " was NULL (expecting a double).";
    barf (NOT_A_NUMBER, details);
  }
  if (sscanf (val, "%lf", &temp) != 1) {
    Dstr details ("The offending input in ");
    details += settingsid();
    details += " was '";
    details += val;
    details += "' (expecting a double).";
    barf (NOT_A_NUMBER, details);
  }
  return temp;
}


int
Settings::getint (char *val) {
  int temp;
  if (!val) {
    Dstr details ("The offending input in ");
    details += settingsid();
    details += " was NULL (expecting an integer).";
    barf (NOT_A_NUMBER, details);
  }
  if (sscanf (val, "%d", &temp) != 1) {
    Dstr details ("The offending input in ");
    details += settingsid();
    details += " was '";
    details += val;
    details += "' (expecting an integer).";
    barf (NOT_A_NUMBER, details);
  }
  return temp;
}

double
Settings::getposdouble (char *val) {
  double temp = getdouble (val);
  if (temp <= 0.0) {
    Dstr details ("The offending input in ");
    details += settingsid();
    details += " was '";
    details += val;
    details += "' (expecting a positive double).";
    barf (NUMBER_RANGE_ERROR, details);
  }
  return temp;
}

double
Settings::getgldouble (char *val) {
  double temp = getdouble (val);
  if (temp != -180.0 &&
      temp != -150.0 &&
      temp != -120.0 &&
      temp != -90.0 &&
      temp != -60.0 &&
      temp != -30.0 &&
      temp !=  0.0 &&
      temp !=  30.0 &&
      temp !=  60.0 &&
      temp !=  90.0 &&
      temp !=  120.0 &&
      temp !=  150.0 &&
      temp !=  360.0) {
    Dstr details ("The offending input in ");
    details += settingsid();
    details += " was '";
    details += val;
    details += "' (expecting one of the following:\n";
    details += "-180 -150 -120 -90 -60 -30 0 30 60 90 120 150 360).";
    barf (NUMBER_RANGE_ERROR, details);
  }
  return temp;
}

unsigned
Settings::getposint (char *val) {
  int temp = getint (val);
  if (temp <= 0) {
    Dstr details ("The offending input in ");
    details += settingsid();
    details += " was '";
    details += val;
    details += "' (expecting a positive int).";
    barf (NUMBER_RANGE_ERROR, details);
  }
  return temp;
}

double
Settings::getposdouble (const Dstr &val) {
  return getposdouble (val.aschar());
}

double
Settings::getgldouble (const Dstr &val) {
  return getgldouble (val.aschar());
}

unsigned
Settings::getposint (const Dstr &val) {
  return getposint (val.aschar());
}

void Settings::save() {
  xmlfilename = getenv ("HOME");
  if (xmlfilename.isNull())
    barf (NOHOMEDIR);
  xmlfilename += "/.xtide.xml";
  FILE *fp = fopen (xmlfilename.aschar(), "w");
  if (!fp) {
    Dstr details (xmlfilename);
    details += ": ";
    details += strerror (errno);
    details += ".";
    barf (CANT_OPEN_FILE, details, 0);
    return;
  }
  fprintf (fp, "<?xml version=\"1.0\"?>\n<xtideoptions ");

  int a;
  for (a=0; a<numcolors; a++)
    if (colors[a].length())
      fprintf (fp, "%s=\"%s\"\n", colorarg[a], colors[a].aschar());

  if (u.length())
    fprintf (fp, "u=\"%s\"\n", u.aschar());
  if (z.length())
    fprintf (fp, "z=\"%s\"\n", z.aschar());
  if (df.length())
    fprintf (fp, "df=\"%s\"\n", df.aschar());
  if (hf.length())
    fprintf (fp, "hf=\"%s\"\n", hf.aschar());
  if (tf.length())
    fprintf (fp, "tf=\"%s\"\n", tf.aschar());
  if (el.length())
    fprintf (fp, "el=\"%s\"\n", el.aschar());
  if (tl.length())
    fprintf (fp, "tl=\"%s\"\n", tl.aschar());
  if (nf.length())
    fprintf (fp, "nf=\"%s\"\n", nf.aschar());
  if (ns.length())
    fprintf (fp, "ns=\"%s\"\n", ns.aschar());

  if (!(gw_isnull))
    fprintf (fp, "gw=\"%u\"\n", gw);
  if (!(gh_isnull))
    fprintf (fp, "gh=\"%u\"\n", gh);
  if (!(tw_isnull))
    fprintf (fp, "tw=\"%u\"\n", tw);
  if (!(th_isnull))
    fprintf (fp, "th=\"%u\"\n", th);
  if (!(cw_isnull))
    fprintf (fp, "cw=\"%u\"\n", cw);
  if (!(ga_isnull))
    fprintf (fp, "ga=\"%f\"\n", ga);
  if (!(lw_isnull))
    fprintf (fp, "lw=\"%f\"\n", lw);
  if (!(gl_isnull))
    fprintf (fp, "gl=\"%f\"\n", gl);

  fprintf (fp, "/>\n");
  fclose (fp);
}

Settings::~Settings() {
}
