// $Id: ConfigDefaults.cc,v 1.1 2000/08/30 22:55:28 dave Exp $
/*  ConfigDefaults  Defaults initialized to settings in config.hh.

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.hh"

ConfigDefaults::ConfigDefaults () {
  colors[Colors::background] = bgdefcolor;
  colors[Colors::foreground] = fgdefcolor;
  colors[Colors::button] = buttondefcolor;
  colors[Colors::daytime] = daydefcolor;
  colors[Colors::datum] = datumdefcolor;
  colors[Colors::ebb] = ebbdefcolor;
  el = extralines;
  colors[Colors::flood] = flooddefcolor;
  colors[Colors::mark] = markdefcolor;
  colors[Colors::msl] = msldefcolor;
  colors[Colors::nighttime] = nightdefcolor;
  gw_isnull = gh_isnull = ga_isnull = cw_isnull = lw_isnull = gl_isnull =
    tw_isnull = th_isnull = 0;
  gw = max (mingwidth, defgwidth);
  gh = max (mingheight, defgheight);
  tw = max (minttywidth, defttywidth);
  th = max (minttyheight, defttyheight);
  ga = defgaspect;
  cw = max (mingwidth, defcwidth);
  u = prefunits;
  z = zulu;
  df = datefmt;
  hf = hourfmt;
  tf = timefmt;
  tl = toplines;
  nf = nofill;
  ns = nosunmoon;
  assert (deflwidth > 0.0);
  lw = deflwidth;
  gl = defgl;
}

char
*ConfigDefaults::settingsid() {
  return "config.hh";
}
