/*  xxTimestamp  Get a Timestamp from the user.
    Last modified 1998-05-03

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xtide.hh"

void
xxTimestampCallback (Widget w, XtPointer client_data, XtPointer call_data) {
  xxTimestamp *e = (xxTimestamp *)client_data;
  char temptime[80];
  sprintf (temptime, "%04u-%02u-%02u %02u:%02u",
    e->year, e->month, e->day, e->hour, e->minute);
  Timestamp t (temptime, e->timezone, e->xtidecontext->settings);
  if (t.isNull()) {
    Dstr details ("The offending input was ");
    details += temptime;
    details += "\nin the time zone ";
    if (e->xtidecontext->settings->z == "n")
      details += e->timezone;
    else
      details += "UTC0";
    barf (MKTIME_FAILED, details, 0);
  } else {
    (*(e->timestampcallback)) (t, e->ptr);
  }
  delete e;
}

static void
xxTimestampCancelCallback (Widget w, XtPointer client_data, XtPointer
call_data) {
  xxTimestamp *e = (xxTimestamp *)client_data;
  e->dismiss();
}

void xxYearButtonCallback (Widget w, XtPointer client_data,
			   XtPointer call_data) {
  struct xxTimestamp::numberedbutton *e =
    (struct xxTimestamp::numberedbutton *)client_data;
  e->parent->year = e->number;
  e->parent->update_buttons();
}

void xxMonthButtonCallback (Widget w, XtPointer client_data,
			   XtPointer call_data) {
  struct xxTimestamp::numberedbutton *e =
    (struct xxTimestamp::numberedbutton *)client_data;
  e->parent->month = e->number;
  e->parent->update_buttons();
}

void xxDayButtonCallback (Widget w, XtPointer client_data,
			   XtPointer call_data) {
  struct xxTimestamp::numberedbutton *e =
    (struct xxTimestamp::numberedbutton *)client_data;
  e->parent->day = e->number;
  e->parent->update_buttons();
}

void xxHourButtonCallback (Widget w, XtPointer client_data,
			   XtPointer call_data) {
  struct xxTimestamp::numberedbutton *e =
    (struct xxTimestamp::numberedbutton *)client_data;
  e->parent->hour = e->number;
  e->parent->update_buttons();
}

void xxMinuteButtonCallback (Widget w, XtPointer client_data,
			   XtPointer call_data) {
  struct xxTimestamp::numberedbutton *e =
    (struct xxTimestamp::numberedbutton *)client_data;
  e->parent->minute = e->number;
  e->parent->update_buttons();
}

void
xxTimestamp::dismiss() {
  delete this;
}

xxTimestamp::~xxTimestamp() {
  unsigned y;
  mypopup->unrealize();
  delete helplabel;
  delete gobutton;
  delete cancelbutton;
  delete yearsbutton;
  delete yearsmenu;
  for (y=globalfirstyear; y<=globallastyear; y++)
    delete yearbuttons[y-globalfirstyear].button;
  delete monthsbutton;
  delete monthsmenu;
  for (y=0; y<12; y++)
    delete monthbuttons[y].button;
  delete daysbutton;
  delete daysmenu;
  for (y=0; y<31; y++)
    delete daybuttons[y].button;
  delete spacelabel1;
  delete hoursbutton;
  delete hoursmenu;
  for (y=0; y<24; y++)
    delete hourbuttons[y].button;
  delete minutesbutton;
  delete minutesmenu;
  for (y=0; y<60; y++)
    delete minutebuttons[y].button;
  delete spacelabel2;
}

void
xxTimestamp::update_buttons() {
  char foo[80];
  Arg args[1] = {
    {XtNlabel, (XtArgVal)foo}
  };
  sprintf (foo, "%04u", year);
  XtSetValues (yearsbutton->manager, args, 1);
  yearsbutton->refresh();
  sprintf (foo, "%02u", month);
  XtSetValues (monthsbutton->manager, args, 1);
  monthsbutton->refresh();
  sprintf (foo, "%02u", day);
  XtSetValues (daysbutton->manager, args, 1);
  daysbutton->refresh();
  sprintf (foo, "%02u", hour);
  XtSetValues (hoursbutton->manager, args, 1);
  hoursbutton->refresh();
  sprintf (foo, "%02u", minute);
  XtSetValues (minutesbutton->manager, args, 1);
  minutesbutton->refresh();
}

xxTimestamp::xxTimestamp (xxTideContext *in_xtidecontext, xxContext *context,
     void (*in_timestampcallback) (Timestamp t, void *in_ptr),
     void *in_ptr, Timestamp init, const Dstr &in_timezone):
xxWindow (in_xtidecontext, context, 1, XtGrabExclusive) {
  assert (!(init.isNull()));
  {
    struct tm *ttm = init.get_tm(in_timezone,in_xtidecontext->settings);
    assert (ttm);
    year = ttm->tm_year + 1900;
    month = ttm->tm_mon + 1;
    day = ttm->tm_mday;
    hour = ttm->tm_hour;
    minute = ttm->tm_min;
  }
  mypopup->setTitle ("Select Time");

#if 0
  {
    Arg args[1] =  {
      {XtNorientation, (XtArgVal)XtorientHorizontal}
    };
    XtSetValues (box->manager, args, 1);
  }
#endif

  ptr = in_ptr;
  timestampcallback = in_timestampcallback;
  timezone = in_timezone;
  unsigned y;

  Arg bgargs[2] =  {
    {XtNbackground, (XtArgVal)mypopup->pixels[Colors::background]},
    {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]}
  };
  Arg buttonargs[4] =  {
    {XtNvisual, (XtArgVal)mypopup->visual},
    {XtNcolormap, (XtArgVal)mypopup->colormap},
    {XtNbackground, (XtArgVal)mypopup->pixels[Colors::button]},
    {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]}
  };
  Arg smallbuttonargs[6] =  {
    {XtNvisual, (XtArgVal)mypopup->visual},
    {XtNcolormap, (XtArgVal)mypopup->colormap},
    {XtNbackground, (XtArgVal)mypopup->pixels[Colors::button]},
    {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]},
    {XtNfont, (XtArgVal)mypopup->tinyfontstruct},
    {XtNvertSpace, (XtArgVal)0}
  };

  {
    Dstr f;
    f = "Adjust year, month, day, hours, and minutes to desired time in time\n\
zone ";
    if (in_xtidecontext->settings->z == "n")
      f += in_timezone;
    else
      f += "UTC0";
    f += " using 24-hour notation instead of AM/PM.";
    Widget labelwidget = XtCreateManagedWidget (f.aschar(), labelWidgetClass,
      box->manager, bgargs, 2);
    helplabel = new xxContext (mypopup, labelwidget);
  }

  // The years menu
  {
    Arg menuargs[5] = {
      {XtNvisual, (XtArgVal)mypopup->visual},
      {XtNcolormap, (XtArgVal)mypopup->colormap},
      {"menuName", (XtArgVal)"yearsmenu"},
      {XtNbackground, (XtArgVal)mypopup->pixels[Colors::button]},
      {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]}
    };
    Widget yearsbuttonwidget = XtCreateManagedWidget ("",
      menuButtonWidgetClass, box->manager, menuargs, 5);
    yearsbutton = new xxContext (mypopup, yearsbuttonwidget);
  }
  {
    Widget menushell = XtCreatePopupShell ("yearsmenu",
      simpleMenuWidgetClass, yearsbutton->manager, buttonargs, 4);
    yearsmenu = new xxContext (mypopup, menushell);
  }
  // Buttons on the years menu
  for (y=globalfirstyear; y<=globallastyear; y++) {
    char n[80];
    sprintf (n, "%04u", y);
    Widget buttonwidget = XtCreateManagedWidget (n, smeBSBObjectClass,
      yearsmenu->manager, smallbuttonargs, 6);
    yearbuttons[y-globalfirstyear].button = new xxContext (mypopup, buttonwidget);
    yearbuttons[y-globalfirstyear].parent = this;
    yearbuttons[y-globalfirstyear].number = y;
    XtAddCallback (buttonwidget, XtNcallback, xxYearButtonCallback, (XtPointer)(&(yearbuttons[y-globalfirstyear])));
  }

  // The months menu
  {
    Arg menuargs[5] = {
      {XtNvisual, (XtArgVal)mypopup->visual},
      {XtNcolormap, (XtArgVal)mypopup->colormap},
      {"menuName", (XtArgVal)"monthsmenu"},
      {XtNbackground, (XtArgVal)mypopup->pixels[Colors::button]},
      {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]}
    };
    Widget monthsbuttonwidget = XtCreateManagedWidget ("",
      menuButtonWidgetClass, box->manager, menuargs, 5);
    monthsbutton = new xxContext (mypopup, monthsbuttonwidget);
  }
  {
    Widget menushell = XtCreatePopupShell ("monthsmenu",
      simpleMenuWidgetClass, monthsbutton->manager, buttonargs, 4);
    monthsmenu = new xxContext (mypopup, menushell);
  }
  // Buttons on the months menu
  for (y=1; y<=12; y++) {
    char n[80];
    sprintf (n, "%02u", y);
    Widget buttonwidget = XtCreateManagedWidget (n, smeBSBObjectClass,
      monthsmenu->manager, buttonargs, 4);
    monthbuttons[y-1].button = new xxContext (mypopup, buttonwidget);
    monthbuttons[y-1].parent = this;
    monthbuttons[y-1].number = y;
    XtAddCallback (buttonwidget, XtNcallback, xxMonthButtonCallback, (XtPointer)(&(monthbuttons[y-1])));
  }

  // The days menu
  {
    Arg menuargs[5] = {
      {XtNvisual, (XtArgVal)mypopup->visual},
      {XtNcolormap, (XtArgVal)mypopup->colormap},
      {"menuName", (XtArgVal)"daysmenu"},
      {XtNbackground, (XtArgVal)mypopup->pixels[Colors::button]},
      {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]}
    };
    Widget daysbuttonwidget = XtCreateManagedWidget ("",
      menuButtonWidgetClass, box->manager, menuargs, 5);
    daysbutton = new xxContext (mypopup, daysbuttonwidget);
  }
  {
    Widget menushell = XtCreatePopupShell ("daysmenu",
      simpleMenuWidgetClass, daysbutton->manager, buttonargs, 4);
    daysmenu = new xxContext (mypopup, menushell);
  }
  // Buttons on the days menu
  for (y=1; y<=31; y++) {
    char n[80];
    sprintf (n, "%02u", y);
    Widget buttonwidget = XtCreateManagedWidget (n, smeBSBObjectClass,
      daysmenu->manager, buttonargs, 4);
    daybuttons[y-1].button = new xxContext (mypopup, buttonwidget);
    daybuttons[y-1].parent = this;
    daybuttons[y-1].number = y;
    XtAddCallback (buttonwidget, XtNcallback, xxDayButtonCallback, (XtPointer)(&(daybuttons[y-1])));
  }

  {
    Widget labelwidget = XtCreateManagedWidget (" ", labelWidgetClass,
      box->manager, bgargs, 2);
    spacelabel1 = new xxContext (mypopup, labelwidget);
  }

  // The hours menu
  {
    Arg menuargs[5] = {
      {XtNvisual, (XtArgVal)mypopup->visual},
      {XtNcolormap, (XtArgVal)mypopup->colormap},
      {"menuName", (XtArgVal)"hoursmenu"},
      {XtNbackground, (XtArgVal)mypopup->pixels[Colors::button]},
      {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]}
    };
    Widget hoursbuttonwidget = XtCreateManagedWidget ("",
      menuButtonWidgetClass, box->manager, menuargs, 5);
    hoursbutton = new xxContext (mypopup, hoursbuttonwidget);
  }
  {
    Widget menushell = XtCreatePopupShell ("hoursmenu",
      simpleMenuWidgetClass, hoursbutton->manager, buttonargs, 4);
    hoursmenu = new xxContext (mypopup, menushell);
  }
  // Buttons on the hours menu
  for (y=0; y<24; y++) {
    char n[80];
    sprintf (n, "%02u", y);
    Widget buttonwidget = XtCreateManagedWidget (n, smeBSBObjectClass,
      hoursmenu->manager, buttonargs, 4);
    hourbuttons[y].button = new xxContext (mypopup, buttonwidget);
    hourbuttons[y].parent = this;
    hourbuttons[y].number = y;
    XtAddCallback (buttonwidget, XtNcallback, xxHourButtonCallback, (XtPointer)(&(hourbuttons[y])));
  }

  // The minutes menu
  {
    Arg menuargs[5] = {
      {XtNvisual, (XtArgVal)mypopup->visual},
      {XtNcolormap, (XtArgVal)mypopup->colormap},
      {"menuName", (XtArgVal)"minutesmenu"},
      {XtNbackground, (XtArgVal)mypopup->pixels[Colors::button]},
      {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]}
    };
    Widget minutesbuttonwidget = XtCreateManagedWidget ("",
      menuButtonWidgetClass, box->manager, menuargs, 5);
    minutesbutton = new xxContext (mypopup, minutesbuttonwidget);
  }
  {
    Widget menushell = XtCreatePopupShell ("minutesmenu",
      simpleMenuWidgetClass, minutesbutton->manager, buttonargs, 4);
    minutesmenu = new xxContext (mypopup, menushell);
  }
  // Buttons on the minutes menu
  for (y=0; y<60; y++) {
    char n[80];
    sprintf (n, "%02u", y);
    Widget buttonwidget = XtCreateManagedWidget (n, smeBSBObjectClass,
      minutesmenu->manager, smallbuttonargs, 6);
    minutebuttons[y].button = new xxContext (mypopup, buttonwidget);
    minutebuttons[y].parent = this;
    minutebuttons[y].number = y;
    XtAddCallback (buttonwidget, XtNcallback, xxMinuteButtonCallback, (XtPointer)(&(minutebuttons[y])));
  }

  {
    Widget labelwidget = XtCreateManagedWidget ("  ", labelWidgetClass,
      box->manager, bgargs, 2);
    spacelabel2 = new xxContext (mypopup, labelwidget);
  }

  {
    Widget buttonwidget = XtCreateManagedWidget ("Go", commandWidgetClass,
      box->manager, buttonargs, 4);
    XtAddCallback (buttonwidget, XtNcallback, xxTimestampCallback,
     (XtPointer)this);
    gobutton = new xxContext (mypopup, buttonwidget);
  }
  {
    Widget buttonwidget = XtCreateManagedWidget ("Cancel", commandWidgetClass,
      box->manager, buttonargs, 4);
    XtAddCallback (buttonwidget, XtNcallback, xxTimestampCancelCallback,
      (XtPointer)this);
    cancelbutton = new xxContext (mypopup, buttonwidget);
  }

  update_buttons();
  mypopup->realize();
}
