/**
 * A client-side 802.1x implementation 
 *
 * This code is released under both the GPL version 2 and BSD licenses.
 * Either license may be used.  The respective licenses are found below.
 *
 * Copyright (C) 2002 Bryan D. Payne & Nick L. Petroni Jr.
 * All Rights Reserved
 *
 * --- GPL Version 2 License ---
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * --- BSD License ---
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  - All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by the University of
 *       Maryland at College Park and its contributors.
 *  - Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************
 * File: wpa.c
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: wpa.c,v 1.1 2004/08/19 02:28:06 chessing Exp $
 * $Date: 2004/08/19 02:28:06 $
 * $Log: wpa.c,v $
 * Revision 1.1  2004/08/19 02:28:06  chessing
 * First piece of WPA patch.  (The patch is growing fast, and this commit is to save what is done so far.)
 *
 *
 *******************************************************************/

#include <string.h>
#include <inttypes.h>

#include "wpa.h"
#include "xsup_debug.h"

void wpa_print_auth_suite(unsigned char asuite)
{
  switch (asuite)
    {
    case 0x00:
      debug_printf(DEBUG_NORMAL, "Reserved\n");
      break;
      
    case 0x01:
      debug_printf(DEBUG_NORMAL, "Unspecified authentication over 802.1X\n");
      break;

    case 0x02:
      debug_printf(DEBUG_NORMAL, "None/WPA-PSK\n");
    }
}

void wpa_print_cipher_suite(unsigned char csuite)
{
  switch (csuite)
    {
    case 0x00:
      debug_printf(DEBUG_NORMAL, "None\n");
      break;

    case 0x01:
      debug_printf(DEBUG_NORMAL, "WEP-40\n");
      break;

    case 0x02:
      debug_printf(DEBUG_NORMAL, "TKIP\n");
      break;

    case 0x03:
      debug_printf(DEBUG_NORMAL, "WRAP\n");
      break;

    case 0x04:
      debug_printf(DEBUG_NORMAL, "CCMP\n");
      break;

    case 0x05:
      debug_printf(DEBUG_NORMAL, "WEP-104\n");
      break;
    }
}


void wpa_parse_ie(char *iedata)
{
  struct wpa_ie_struct *ie_struct;
  char wpa_oui[3] = {0x00, 0x50, 0xf2};
  char suite_id[4];
  int i, ieptr;
  uint16_t value16;

  ie_struct = (struct wpa_ie_struct *)iedata;

  if (ie_struct->wpaid != 0xdd)
    {
      debug_printf(DEBUG_NORMAL, "IE is not a valid WPA IE! (Invalid vendor value!)\n");
      return;
    }

  debug_printf(DEBUG_NORMAL, "--- WPA Data ---\n");
  
  if ((memcmp(ie_struct->oui, wpa_oui, 3) != 0) && (ie_struct->oui[4] != 0x01))
    {
      debug_printf(DEBUG_NORMAL, "IE is not a valid WPA IE! (Invalid OUI value!\n");
      return;
    }

  debug_printf(DEBUG_NORMAL, "WPA Version : %d\n", ie_struct->wpa_ver);
  debug_printf(DEBUG_NORMAL, "Group Key Cipher Suite : ");
  wpa_print_cipher_suite(ie_struct->group_cipher[4]);

  debug_printf(DEBUG_NORMAL, "Pairwise Key Cipher Suite Count : %d\n",
	       ie_struct->pk_suite_cnt);

  ieptr = sizeof(struct wpa_ie_struct);

  for (i=0;i<ie_struct->pk_suite_cnt;i++)
    {
      debug_printf(DEBUG_NORMAL, "Cipher Suite : ");
      memcpy((char *)&suite_id, (char *)&iedata[ieptr], 4);

      if (memcmp(suite_id, wpa_oui, 3) != 0)
	{
	  debug_printf(DEBUG_NORMAL, "Invalid WPA OUI!\n");
	} else {
	  wpa_print_cipher_suite(suite_id[3]);
	}

      ieptr+=4;
    }

  memcpy((char *)&value16, (char *)&iedata[ieptr], 2);
  ieptr+=2;
  debug_printf(DEBUG_NORMAL, "Authenticated Key Management Suite Count : %d\n",
	       value16);

  for (i=0;i<value16;i++)
    {
      debug_printf(DEBUG_NORMAL, "Authentication Suite : ");
      memcpy((char *)&suite_id, (char *)&iedata[ieptr], 4);

      if (memcmp(suite_id, wpa_oui, 3) != 0)
	{
	  debug_printf(DEBUG_NORMAL, "Invalid WPA OUI!\n");
	} else {
	  wpa_print_auth_suite(suite_id[3]);
	}
      ieptr+=4;
    }

  if (ieptr < ie_struct->wpalen)
    {
      memcpy((char *)&value16, (char *)&iedata[ieptr], 2);
      debug_printf(DEBUG_NORMAL, "RSN Capabilities : %04X\n\n", value16);
    }
}
