/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SIDIDDIALOG_H
#define SIDIDDIALOG_H

#include "SidIdDialogData.h"
#include "SidIdConfig.h"
#include "sidid/sidid.h"

#include <qvariant.h>
#include <qdialog.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QPushButton;
class QLabel;
class QLineEdit;
class QFrame;

class SidIdDialog : public SidIdDialogData
{
    Q_OBJECT

public:
    SidIdDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~SidIdDialog();

    void setConfig(const SidIdConfig&);
    const SidIdConfig& getConfig() const;

   /**
    * Set the sidId to use
    *
    * @param sidId the SidId to use
    */
    void setSidId(SidId* sidId);

protected slots:

    virtual void okButtonClicked();
    virtual void cancelButtonClicked();
    virtual void browseButtonClicked();

protected:
    SidIdConfig config;
    SidIdConfig backupConfig;

    void update();

    SidId* mySidId;

};

#endif // SIDIDDIALOG_H
