//
// STIL - Common defines
//

#ifndef _STILDEFS_H
#define _STILDEFS_H

#include <sidplay/compconf.h>

// On a per OS basis:
// - Define what the pathname separator is.
// - Define what the function is to compare strings case-insensitively.
// - Define what the function is to compare portions of strings case-insensitively.
//
#define SLASH '/'
#ifdef SID_HAVE_STRCASECMP
#define MYSTRCMP strcasecmp
#else
#define MYSTRCMP stricmp
#endif
#ifdef SID_HAVE_STRNCASECMP
#define MYSTRNCMP strncasecmp
#else
#define MYSTRNCMP strnicmp
#endif

// Common definition for boolean
// NOTE: Comment these out if 'bool' is a recognized type on your compiler!
// typedef int bool;
// #define false 0
// #define true 1

// These are the hardcoded STIL/BUG field names.
const char    _NAME_STR[]="   NAME: ";
const char   _TITLE_STR[]="  TITLE: ";
const char  _ARTIST_STR[]=" ARTIST: ";
const char _COMMENT_STR[]="COMMENT: ";
const char     _BUG_STR[]="BUG: ";

// Maximum size of a single line in STIL - also accounts for some extra
// padding, just in case.
#define STIL_MAX_LINE_SIZE 129

// Maximum size of a single STIL entry (in bytes).
#define STIL_MAX_ENTRY_SIZE STIL_MAX_LINE_SIZE*100

// HVSC path to STIL.
const char PATH_TO_STIL[]="/DOCUMENTS/STIL.txt";

// HVSC path to BUGlist.
const char PATH_TO_BUGLIST[]="/DOCUMENTS/BUGlist.txt";

#endif // _STILDEFS_H
