/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef AUDIOBASE_H
#define AUDIOBASE_H

#include "AudioConfig.h"

class AudioBase
{
protected:  // ---------------------------------------------------- protected
	
	AudioConfig config;
	char* errorString;

public:  // ---------------------------------------------------------- public
	
	AudioBase() { errorString = "No driver."; }
	virtual ~AudioBase() { ; }

	virtual bool open(const AudioConfig& srcConfig) = 0;
	virtual void close() = 0;
	virtual bool reset() = 0;
	virtual void play(void* buffer, unsigned long int bufferSize) = 0;

	const AudioConfig& getConfig() const
	{
		return config;
	}
	
	const char* getErrorString() const
	{
		return errorString;
	}
};

#endif  /* AUDIOBASE_H */
