# file      : build/cxx/intel/cxx-o.make
# author    : Boris Kolpackov <boris@kolpackov.net>
# copyright : Copyright (c) 2004-2007 Boris Kolpackov
# license   : GNU GPL v2; see accompanying LICENSE file

$(call include-once,$(bld_root)/c/cpp-options.make,$(out_base))
$(call include,$(bld_root)/cxx/intel/configuration.make)

# Make will try to build dependecies (since they are ultimately included
# files) during configuartion phase without cxx_intel being discovered yet.
# This is also why dependecies should be included with -include.
#
ifdef cxx_intel

$(out_base)/%.o.d: cxx := $(cxx_intel)
$(out_base)/%.o.d: cpp_options ?=

#@@ This needs to be shared with cxx-o.
#
#@@ wrong prefix
#
$(out_base)/%.o.d: expand-cpp-options-impl = \
$(if $1,$(shell sed -e 's%include: \(.*\)%\1%' -e t -e d $1))

$(out_base)/%.o.d: expand-cpp-options = \
$(call expand-cpp-options-impl,$(filter %.cpp-options,$1))


# Makes prefix-appending sed script from cpp-options' prefix: lines.
#
$(out_base)/%.o.d: make-prefix-script-impl = \
$(if $1,$(shell sed -e 's%prefix: \([^ ]*\) \([^ ]*\)%s \\ \1 \\ \2\1 g;s ^\1 \2\1 ;%' -e t -e d $1))

$(out_base)/%.o.d: make-prefix-script = \
$(call make-prefix-script-impl,$(filter %.cpp-options,$1))

$(out_base)/%.o.d: make-sed-command = \
| sed -e '$(if $(strip $1),$1)s% \([^/ \\]\)% $(out_base)/\1%g;s%^\([^/ ].*:\)%$(out_base)/\1%' >$2


.PRECIOUS: $(out_base)/%.o.d

$(out_base)/%.o.d: $(out_base)/%.$(cxx_s_suffix) | $$(dir $$@).
	$(call message,,if test -f $@; then mv $@ $@.old; fi && \
$(cxx) $(cpp_options) $(call expand-cpp-options,$^) $(cxx_pp_extra_options) \
$(cxx_extra_options) -M -MG -MP -MQ $@ -MQ $(basename $@) $< \
$(call make-sed-command,$(call make-prefix-script,$^),$@) && \
if test -f $@.old; then if cmp -s $@ $@.old; then rm -f $@.old && false; \
else rm -f $@.old && true; fi fi)


ifneq ($(out_base),$(src_base))

$(out_base)/%.o.d: $(src_base)/%.$(cxx_s_suffix) | $$(dir $$@).
	$(call message,,if test -f $@; then mv $@ $@.old; fi && \
$(cxx) $(cpp_options) $(call expand-cpp-options,$^) $(cxx_pp_extra_options) \
$(cxx_extra_options) -M -MG -MP -MQ $@ -MQ $(basename $@) $< \
$(call make-sed-command,$(call make-prefix-script,$^),$@) && \
if test -f $@.old; then if cmp -s $@ $@.old; then rm -f $@.old && false; \
else rm -f $@.old && true; fi fi)

endif


.PHONY: $(out_base)/%.o.d.$(cxx_s_suffix).clean

$(out_base)/%.o.d.$(cxx_s_suffix).clean:
	$(call message,rm $$1,rm -f $$1,$(basename $(basename $@)))

endif
