/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/slinkcombo.c,v 1.16 2004/02/26 06:34:56 justins Exp $ */
/*

   xscorch - slinkcombo.c     Copyright(c) 2000-2003 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Scorched combolist widgets


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, version 2 of the License ONLY.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>

#include <slinkcombo.h>

#include <gdk/gdkkeysyms.h>
#include <libj/jstr/libjstr.h>



enum _ScLinkComboSignals {
   MODIFIED_SIGNAL,
   LAST_SIGNAL
};
static guint _sc_link_combo_signals[LAST_SIGNAL] = { 0 };



static void _sc_link_combo_set(GtkEntry *entry, ScLinkCombo *combo) {

   const char **entries;
   const char *curtext;
   gint i;

   entries = g_object_get_data(G_OBJECT(entry), "user_data");
   if(entries == NULL) return;

   curtext = gtk_entry_get_text(GTK_ENTRY(entry));
   for(i = 0; entries[i] != NULL; ++i) {
      if(strequal(entries[i], curtext)) {
         if(combo->value != NULL) *combo->value = i;
         #if GTK12_ENABLED
            gtk_signal_emit(GTK_OBJECT(combo), _sc_link_combo_signals[MODIFIED_SIGNAL]);
         #else /* GTK 2.0 */
            g_signal_emit(GTK_OBJECT(combo), _sc_link_combo_signals[MODIFIED_SIGNAL], 0);
         #endif /* GTK version? */
         return;
      }
   }

}



static void _sc_link_combo_class_init(ScLinkComboClass *klass) {

   GtkObjectClass *object_class = (GtkObjectClass *)klass;

   #if GTK12_ENABLED
      _sc_link_combo_signals[MODIFIED_SIGNAL] =
         gtk_signal_new("modified",
                        GTK_RUN_LAST,
                        GTK_CLASS_TYPE(object_class),
                        GTK_SIGNAL_OFFSET(ScLinkComboClass, modified),
                        gtk_marshal_NONE__NONE,
                        GTK_TYPE_NONE, 0);

      /* This call is no longer necessary in 2.0 */
      gtk_object_class_add_signals(object_class, _sc_link_combo_signals, LAST_SIGNAL);
   #else /* GTK 2.0 */
      _sc_link_combo_signals[MODIFIED_SIGNAL] =
         g_signal_new("modified",                     /* Signal name */
                      G_TYPE_FROM_CLASS(object_class),/* Type of object the signal applies to */
                      G_SIGNAL_RUN_LAST,              /* Signal flags; run this signal last */
                      offsetof(ScLinkComboClass, modified),
                                                      /* Offset to signal handler in class */
                      NULL,                           /* Signal accumulator function */
                      NULL,                           /* Signal accumulator data */
                      g_cclosure_marshal_VOID__VOID,  /* Marshal function for this signal */
                      G_TYPE_NONE,                    /* Return type for the marshaller */
                      0                               /* Number of extra parametres to pass */
                     );
   #endif /* GTK version? */

   klass->modified = NULL;

}



static void _sc_link_combo_init_obj(ScLinkCombo *combo) {

   combo->value = NULL;

   #if GTK12_ENABLED
      gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry), "changed", GTK_SIGNAL_FUNC(_sc_link_combo_set), combo);
   #else /* GTK 2.0 */
      g_signal_connect(G_OBJECT(GTK_COMBO(combo)->entry), "changed", (GCallback)_sc_link_combo_set, combo);
   #endif /* GTK version? */

}



GType sc_link_combo_get_type(void) {

   static GType sc_link_combo_type = 0;

   if(sc_link_combo_type == 0) {
      #if GTK12_ENABLED
         static const GtkTypeInfo sc_link_combo_info = {
            (char *)"ScLinkCombo",
            sizeof(ScLinkCombo),
            sizeof(ScLinkComboClass),
            (GtkClassInitFunc)_sc_link_combo_class_init,
            (GtkObjectInitFunc)_sc_link_combo_init_obj,
            NULL,
            NULL,
            (GtkClassInitFunc)NULL
         };
         sc_link_combo_type = gtk_type_unique(gtk_combo_get_type(), &sc_link_combo_info);
      #else /* GTK 2.0 */
         static const GTypeInfo sc_link_combo_info = {
            sizeof(ScLinkComboClass),        /* Size of the class object */
            NULL,                            /* Base initializer */
            NULL,                            /* Base finalizer */
            (GClassInitFunc)_sc_link_combo_class_init,
                                             /* Class initializer */
            NULL,                            /* Class finalizer */
            NULL,                            /* Class data pointer */
            sizeof(ScLinkCombo),             /* Size of an instance object */
            0,                               /* Number of preallocs */
            (GInstanceInitFunc)_sc_link_combo_init_obj,
                                             /* Instance initializer */
            NULL                             /* Value table */
         };
         sc_link_combo_type = g_type_register_static(gtk_combo_get_type(), "ScLinkCombo",
                                                     &sc_link_combo_info, 0);
      #endif /* GTK version? */
   }

   return(sc_link_combo_type);

}



GtkWidget *sc_link_combo_new(int *value, const char **entries) {

   ScLinkCombo *combo;
   GList *items = NULL;
   gint i;

   combo = g_object_new(sc_link_combo_get_type(), NULL);
   g_return_val_if_fail(combo != NULL, NULL);

   for(i = 0; entries[i] != NULL; ++i) {
      items = g_list_append(items, (char *)entries[i]);
   }

   gtk_combo_set_popdown_strings(GTK_COMBO(combo), items);
   gtk_combo_set_value_in_list(GTK_COMBO(combo), TRUE, FALSE);
   gtk_widget_set_size_request(GTK_WIDGET(combo), 130, -1);
   g_object_set_data(G_OBJECT(GTK_COMBO(combo)->entry), "user_data", entries);
   gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), entries[*value]);
   combo->value = value;

   return(GTK_WIDGET(combo));

}



