/* $Header: /fridge/cvs/xscorch/xscorch.c,v 1.2 2001/04/07 19:59:29 justins Exp $ */
/*
   
   xscorch - xscorch.c        Copyright(c) 2001,2000 Justin David Smith
                              Copyright(c) 2001,2000 Jacob Luna Lundberg
   justins(at)chaos2.org      http://chaos2.org/
   jacob(at)chaos2.org        http://chaos2.org/~jacob
    
   Scorched Earth, main function
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdio.h>
#include <stdlib.h>
#include <xscorch.h>
#include <sconfig.h>
#include <swindow.h>
#include <sland.h>
#include <sinfo.h>



#if !HAVE_GETTIMEOFDAY
#error "This program requires gettimeofday()"
#endif



int main(int argc, char **argv) {

   sc_config *c;
   sc_window *w;

   sc_info();
   
   /* Create game configuration, X window.
      Parse command line options, and load
      images.                              */   
   if(!(c = sc_config_new(&argc, &argv))) return(1);
   if(!(w = sc_window_new(c, argc, argv))) return(1);
   
   sc_land_generate(c, c->land);
   
   sc_window_run(w);
   
   /* Release all data */   
   sc_window_free(&w);
   sc_config_free(&c);

   printf("War is the science of destruction.  -- John Abbott\n");

   return(0);

}
