/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/slabel.c,v 1.2 2001/04/07 19:46:50 justins Exp $ */
/*
   
   xscorch - slabel.c         Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Scorched label widgets
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>
#include <slabel.h>
#include <gdk/gdkkeysyms.h>



static void _sc_label_class_init(ScLabelClass *klass) {

}



static void _sc_label_init_obj(ScLabel *label) {
   
}



GtkType sc_label_get_type(void) {

   static GtkType sc_label_type = 0;
   
   if(sc_label_type == 0) {
      static const GtkTypeInfo sc_label_info = {
         (char *)"ScLabel",
         sizeof(ScLabel),
         sizeof(ScLabelClass),
         (GtkClassInitFunc)_sc_label_class_init,
         (GtkObjectInitFunc)_sc_label_init_obj,
         (GtkArgSetFunc)NULL,
         (GtkArgGetFunc)NULL
      };
      sc_label_type = gtk_type_unique(gtk_label_get_type(), &sc_label_info);
   }
    
   return(sc_label_type);

}  



GtkWidget *sc_label_new(const char *text) {

   ScLabel *label;
   
   label = gtk_type_new(sc_label_get_type());
   g_return_val_if_fail(label != NULL, NULL);

   gtk_label_set_text(GTK_LABEL(label), text);
   gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
      
   return(GTK_WIDGET(label));

}



