/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/sdisplay.c,v 1.2 2001/04/07 19:46:50 justins Exp $ */
/*
   
   xscorch - sdisplay.c       Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Control for containing a sdisplay with an optional console
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <sdisplay.h>



static void _sc_display_class_init(ScDisplayClass *klass) {
   
}



static void _sc_display_init_obj(ScDisplay *dpy) {

   dpy->draw = NULL;
   GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(dpy), GTK_CAN_FOCUS);

}



GtkType sc_display_get_type(void) {

   static GtkType sc_display_type = 0;
   
   if(sc_display_type == 0) {
      static const GtkTypeInfo sc_display_info = {
         (char *)"ScDisplay",
         sizeof(ScDisplay),
         sizeof(ScDisplayClass),
         (GtkClassInitFunc)_sc_display_class_init,
         (GtkObjectInitFunc)_sc_display_init_obj,
         (GtkArgSetFunc)NULL,
         (GtkArgGetFunc)NULL
      };
      sc_display_type = gtk_type_unique(gtk_fixed_get_type(), &sc_display_info);
   }

   return(sc_display_type);

}



GtkWidget *sc_display_new(gint width, gint height) {

   ScDisplay *dpy;

   dpy = gtk_type_new(sc_display_get_type());
   g_return_val_if_fail(dpy != NULL, NULL);
   
   dpy->draw = sc_drawbuf_new(width, height);
   gtk_fixed_put(GTK_FIXED(dpy), dpy->draw, 0, 0);
   gtk_widget_show(dpy->draw);
   
   return(GTK_WIDGET(dpy));

}



void sc_display_console_attach(ScDisplay *dpy, ScConsole *cons) {

   gtk_fixed_put(GTK_FIXED(dpy), GTK_WIDGET(cons), cons->req_alloc.x, cons->req_alloc.y);
   gtk_widget_show(GTK_WIDGET(cons));
   
}



gboolean sc_display_console_detach(ScDisplay *dpy) {

   GtkFixedChild *child;
   GtkWidget *cwidget;
   GList *children;

   children = GTK_FIXED(dpy)->children;
   
   if(children == NULL || children->next == NULL) return(FALSE);
   while(children->next != NULL) children = children->next;
   child = children->data;
   cwidget = child->widget;

   gtk_container_remove(GTK_CONTAINER(dpy), cwidget);
   /*gtk_widget_destroy(cwidget);*/
   return(TRUE);

}



void sc_display_console_detach_all(ScDisplay *dpy) {

   while(sc_display_console_detach(dpy)) /* Just loop */;

}



void sc_display_queue_draw(ScDisplay *dpy, gint x, gint y, gint width, gint height) {

   sc_drawbuf_queue_draw(SC_DRAWBUF(sc_display_get_drawbuf(dpy)), x, y, width, height);

}



